#!/bin/bash
set -eu


## Constants
#
VER="3.15.0"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://ftp.mcs.anl.gov/pub/petsc/release-snapshots/petsc-3.15.0.tar.gz' 'petsc-3.15.0.tar.gz'

# Unpack source
tar -zxvf petsc-3.15.0.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to $PETSC_DIR
mv petsc-3.15.0/* src/
rm -rf petsc-3.15.0


# Configure
#
# NOTE: Based on /nasa/petsc/3.7.5/intel_mpt/lib/petsc/conf/petscvariables; look for CONFIGURE_OPTIONS
#
cd src
./config/configure.py \
	--prefix="${ISSM_DIR}/externalpackages/petsc/install" \
	--PETSC_DIR="${ISSM_DIR}/externalpackages/petsc/src" \
	--with-blas-lapack-dir="/nasa/intel/Compiler/2018.3.222/compilers_and_libraries_2018.3.222/linux/mkl" \
	--with-scalapack-include=/nasa/intel/Compiler/2018.3.222/mkl/include \
	--with-scalapack-lib="/nasa/intel/Compiler/2018.3.222/mkl/lib/intel64/libmkl_scalapack_lp64.so /nasa/intel/Compiler/2018.3.222/mkl/lib/intel64/libmkl_blacs_intelmpi_lp64.so" \
	--with-make-np=10 \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=0

# Compile and install
make
make install
