#!/bin/bash
set -eu


# NOTE: There is a single difference between the Linux and macOS 
#		configurations, which is the addition of the -static-libgfortran 
#		option to FFLAGS on the macOS static configurations. For the sake of 
#		consistency, we maintain separate files for each, respective Linux and 
#		macOS configuration.

# Constants
VER="3.14.0"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://ftp.mcs.anl.gov/pub/petsc/release-snapshots/petsc-lite-${VER}.tar.gz" "petsc-${VER}.tar.gz"

# Unpack source
tar -zxvf petsc-${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv petsc-${VER}/* src/
rm -rf petsc-${VER}

# Configure
cd src
./config/configure.py \
	COPTFLAGS="-g -O3" CXXOPTFLAGS="-g -O3" FOPTFLAGS="-g -O3" \
	--prefix="${ISSM_DIR}/externalpackages/petsc/install" \
	--PETSC_DIR="${ISSM_DIR}/externalpackages/petsc/src" \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-pic=1 \
	--with-batch=1 \
	--with-blas-lapack-dir="/nasa/intel/Compiler/2018.3.222/compilers_and_libraries_2018.3.222/linux/mkl" \
	--with-scalapack-include=/nasa/intel/Compiler/2018.3.222/mkl/include \
	--with-scalapack-lib="/nasa/intel/Compiler/2018.3.222/mkl/lib/intel64/libmkl_scalapack_lp64.so /nasa/intel/Compiler/2018.3.222/mkl/lib/intel64/libmkl_blacs_intelmpi_lp64.so" \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-scalapack=0 \
	--download-mumps=1

# Compile and install
make
make install
