/*!\file: sampling_core.cpp
 * \brief: core of the sampling solution
 */

#include "../classes/classes.h"
#include "../solutionsequences/solutionsequences.h"

void sampling_core(FemModel* femmodel){

	/*Start profiler*/
	femmodel->profiler->Start(SAMPLINGCORE);

	/*parameters: */
	int    numoutputs;
	bool   save_results;
	int    solution_type;
	char** requested_outputs = NULL;

	/*activate configuration*/
	femmodel->SetCurrentConfiguration(SamplingAnalysisEnum);

	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);
	femmodel->parameters->FindParam(&numoutputs,SamplingNumRequestedOutputsEnum);
	if(numoutputs) femmodel->parameters->FindParam(&requested_outputs,&numoutputs,SamplingRequestedOutputsEnum);

	if(VerboseSolution()) _printf0_("   Generating random samples\n");

	/*Generate random sample*/
	if(VerboseSolution()) _printf0_("   call computational core\n");
	femmodel->SetCurrentConfiguration(SamplingAnalysisEnum);
	solutionsequence_sampling(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		int outputs = SampleEnum;
		femmodel->RequestedOutputsx(&femmodel->results,&outputs,1);
	}

	if(solution_type==SamplingSolutionEnum)femmodel->RequestedDependentsx();

	/*Free ressources:*/
	if(numoutputs){for(int i=0;i<numoutputs;i++){xDelete<char>(requested_outputs[i]);} xDelete<char*>(requested_outputs);}

	/*profiler*/
	femmodel->profiler->Stop(SAMPLINGCORE);
}
