/*!\file SealevelGeometry.h
 * \brief: header file for SealevelMask geometry
 */

#ifndef _SEALEVELGEOMETRY_H_
#define _SEALEVELGEOMETRY_H_

/*Headers:*/
#define SLGEOM_NUMLOADS 3
#define SLGEOM_OCEAN 0 
#define SLGEOM_ICE 1 
#define SLGEOM_WATER 2
#define SLMAXVERTICES 3

#include "../toolkits/toolkits.h"

class SealevelGeometry{ 

	public: 

		int         localnel;
		IssmDouble* LoadWeigths[SLGEOM_NUMLOADS][SLMAXVERTICES];
		IssmDouble* LoadArea[SLGEOM_NUMLOADS];
		Vector<IssmDouble>* vlatbarycentre[SLGEOM_NUMLOADS];
		Vector<IssmDouble>* vlongbarycentre[SLGEOM_NUMLOADS];
		Vector<IssmDouble>* vareae_subel[SLGEOM_NUMLOADS];
		IssmDouble* latbarycentre[SLGEOM_NUMLOADS];
		IssmDouble* longbarycentre[SLGEOM_NUMLOADS];
		IssmDouble* area_subel[SLGEOM_NUMLOADS];
		IssmDouble* late;
		IssmDouble* longe;
		bool* isoceanin;
		bool*       issubelement[SLGEOM_NUMLOADS]; 
		int*        subelementmapping[SLGEOM_NUMLOADS];
		int         nsubel[SLGEOM_NUMLOADS];
		int         nbar[SLGEOM_NUMLOADS];
		int*        lids; 

		SealevelGeometry(int localnel,int localnods);
		~SealevelGeometry();
		void InitializeMappingsAndBarycentres(void);
		void Assemble(void);
		int GEnum(int l);
		int GUEnum(int l);
		int GNEnum(int l);
		int GEEnum(int l);
};
#endif  /* _SEALEVELGEOMETRY_H_ */
