#Friction class definition

abstract type CoreFriction end
struct CoreBuddFriction#{{{
	H_input::ElementInput
	b_input::ElementInput
	c_input::ElementInput
	rho_ice::Float64
	rho_water::Float64
	g::Float64
end# }}}
function CoreFriction(element::Tria) #{{{

	frictionlaw = FindParam(element, FrictionLawEnum)

	if frictionlaw==1
		H_input  = GetInput(element, ThicknessEnum)
		b_input  = GetInput(element, BaseEnum)
		c_input  = GetInput(element, FrictionCoefficientEnum)

		rho_ice   = FindParam(element, MaterialsRhoIceEnum)
		rho_water = FindParam(element, MaterialsRhoSeawaterEnum)
		g         = FindParam(element, ConstantsGEnum)

		return CoreBuddFriction(H_input, b_input, c_input, rho_ice, rho_water, g)
	else
		error("Friction ",typeof(md.friction)," not supported yet")
	end
end#}}}

#vertices functions
function Alpha2(friction::CoreBuddFriction, gauss::GaussTria, i::Int64) #{{{

	#Get effective pressure
	H = GetInputValue(friction.H_input, gauss, i)
	b = GetInputValue(friction.b_input, gauss, i)
	c = GetInputValue(friction.c_input, gauss, i)
	N = friction.rho_ice*friction.g*H + friction.rho_water*friction.g*b

	if(N<0) N=0 end

	return c^2*N
end #}}}
