include("../md/classes.jl")
include("./issmenums.jl")
include("./toolkits.jl")
include("./gauss.jl")
include("./parameters.jl")
include("./inputs.jl")
include("./vertices.jl")
include("./nodes.jl")
include("./elements.jl")
include("./constraints.jl")
include("./matice.jl")
include("./femmodel.jl")
include("./analyses/analysis.jl")
include("./analyses/stressbalanceanalysis.jl")
include("./solutionsequences.jl")
include("./modules.jl")
include("./elementmatrix.jl")
include("./utils.jl")

function IssmCore(md::model) #{{{

	#Construct FemModel
	femmodel=ModelProcessor(md)

	#Solve
	analysis = StressbalanceAnalysis()
	Core(analysis,femmodel)

	#Save output
	RequestedOutputsx(femmodel,[VxEnum,VyEnum])
	error("STOP")

end# }}}
