function dvar=QmuSetupDesign(dvar,variables,params,varargin)

%get descriptor
descriptor=variables.descriptor;

%loop on descriptor
if strcmpi(descriptor,'rho_ice')

	dvar=setuprhoice(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'rho_water')

	dvar=setuprhowater(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'heatcapacity')

	dvar=setupheatcapacity(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'thermalconductivity')

	dvar=setupthermalconductivity(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'gravity')

	dvar=setupgravity(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'thickness')

	dvar=setupthickness(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'drag')

	dvar=setupdrag(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'riftsfriction')

	dvar=setupriftsfriction(dvar,variables,params,varargin{:});

else
	error(['QmuSetupDesign warning message: could not find ' descriptor ' setup design function']);
end

end
