
#Toolkit #1: serial sparse arrays
using SparseArrays

#Matrix
mutable struct IssmMatrix #{{{
	matrix::SparseMatrixCSC{Float64,Int64}
end #}}}
function IssmMatrix(M::Int64,N::Int64)#{{{
	return IssmMatrix(spzeros(M,N))
end#}}}
function AddValues!(matrix::IssmMatrix,m::Int64,midx::Vector{Int64},n::Int64,nidx::Vector{Int64},values::Matrix{Float64})#{{{

	#This is inefficient now, but it will work
	for i in 1:m
		if(midx[i]==-1) continue end
		for j in 1:n
			if(nidx[j]==-1) continue end
			matrix.matrix[midx[i],nidx[j]] += values[i,j]
		end
	end

end#}}}
function GetSize(matrix::IssmMatrix)#{{{

	return size(matrix.matrix)

end#}}}

#Vector
mutable struct IssmVector #{{{
	vector::Vector{Float64}
end #}}}
function IssmVector(M::Int64)#{{{
	return IssmVector(zeros(M))
end#}}}
function GetSize(vector::IssmVector)#{{{

	return length(vector.vector)

end#}}}
function AddValues!(vector::IssmVector,m::Int64,midx::Vector{Int64},values::Vector{Float64})#{{{

	#This is inefficient now, but it will work
	for i in 1:m
		if(midx[i]==-1) continue end
		vector.vector[midx[i]] += values[i]
	end

end#}}}
function SetValues!(vector::IssmVector,m::Int64,midx::Vector{Int64},values::Vector{Float64})#{{{

	#This is inefficient now, but it will work
	for i in 1:m
		if(midx[i]==-1) continue end
		vector.vector[midx[i]] = values[i]
	end

end#}}}

#Operations
function MatMult!(A::IssmMatrix,x::IssmVector,y::IssmVector) #{{{

	y.vector = A.matrix*x.vector

end#}}}
function AXPY!(y::IssmVector,alpha::Float64,x::IssmVector) #{{{

	y.vector = alpha*x.vector + y.vector

end#}}}
function Solverx(A::IssmMatrix,b::IssmVector,xold::IssmVector) #{{{

	x = IssmVector(GetSize(xold))
	x.vector = (A.matrix\b.vector)

	return x


end#}}}

