function solutionsequence_nonlinear(femmodel::FemModel,analysis::Analysis,maxiter::Int64,restol::Float64,reltol::Float64,abstol::Float64) # {{{

	#Initialize number of iterations
	count = 0
	converged = false

	#Get existing solution
	ug = GetSolutionFromInputsx(analysis,femmodel)
	uf = Reducevectorgtofx(ug,femmodel.nodes)

	#Update once again the solution to make sure that vx and vxold are similar (for next step in transient or steadystate)
	InputUpdateFromSolutionx(analysis,ug,femmodel)

	#Loop until we reach convergence
	while(~converged)

		#Get new matrices
		Kff, Kfs, pf = SystemMatricesx(femmodel,analysis)

		#Enforce constraints
		ys = CreateNodalConstraintsx(femmodel.nodes)
		Reduceloadx!(pf, Kfs, ys)

		#Solve!
		old_uf = uf
		uf = Solverx(Kff, pf, old_uf)

		print(uf)
		error("compare with ISSM...")

		#Increase count
		count += 1
		if(count>maxiter)
			println("   maximum number of nonlinear iterations (",maxiter,") exceeded")
			converged = true
		end
	end

	error("STOP")

end# }}}
