
#Toolkit #1: serial sparse arrays
using SparseArrays
mutable struct IssmMatrix #{{{
	matrix::SparseMatrixCSC{Float64,Int64}
end #}}}
function IssmMatrix(M::Int64,N::Int64)#{{{
	return IssmMatrix(spzeros(M,N))
end#}}}
function AddValues!(matrix::IssmMatrix,m::Int64,midx::Vector{Int64},n::Int64,nidx::Vector{Int64},values::Matrix{Float64})#{{{

	#This is inefficient now, but it will work
	for i in 1:m
		if(midx[i]==-1) continue end
		for j in 1:n
			if(nidx[j]==-1) continue end
			matrix.matrix[midx[i],nidx[j]] += values[i,j]
		end
	end

end#}}}

mutable struct IssmVector #{{{
	vector::Vector{Float64}
end #}}}
function IssmVector(M::Int64)#{{{
	return IssmVector(zeros(M))
end#}}}
function AddValues!(vector::IssmVector,m::Int64,midx::Vector{Int64},values::Vector{Float64})#{{{

	#This is inefficient now, but it will work
	for i in 1:m
		if(midx[i]==-1) continue end
		vector.vector[midx[i]] += values[i]
	end

end#}}}
function SetValues!(vector::IssmVector,m::Int64,midx::Vector{Int64},values::Vector{Float64})#{{{

	#This is inefficient now, but it will work
	for i in 1:m
		if(midx[i]==-1) continue end
		vector.vector[midx[i]] = values[i]
	end

end#}}}
