mutable struct ElementMatrix#{{{
	nrows::Int64
	gglobaldoflist::Vector{Int64}
	fglobaldoflist::Vector{Int64}
	sglobaldoflist::Vector{Int64}
	values::Matrix{Float64}
end #}}}
function ElementMatrix(nodes::Vector{Node})#{{{

	#Get matrix size
	nrows = NumberOfDofs(nodes,GsetEnum)

	#Initialize element matrix with zeros
	values = zeros(nrows,nrows)

	#Get dof lists
	gglobaldoflist=GetGlobalDofList(nodes,nrows,GsetEnum)
	fglobaldoflist=GetGlobalDofList(nodes,nrows,FsetEnum)
	sglobaldoflist=GetGlobalDofList(nodes,nrows,SsetEnum)

	return ElementMatrix(nrows,gglobaldoflist,fglobaldoflist,sglobaldoflist,values)
end#}}}
function Base.show(io::IO, this::ElementMatrix)# {{{

	println(io,"ElementMatrix:")
	println(io,"   nrows: ",this.nrows)
	println(io,"   gglobaldoflist: ",this.gglobaldoflist)
	println(io,"   fglobaldoflist: ",this.fglobaldoflist)
	println(io,"   sglobaldoflist: ",this.sglobaldoflist)
	print(io,"   values: ")
	display(this.values)
end# }}}

mutable struct ElementVector#{{{
	nrows::Int64
	fglobaldoflist::Vector{Int64}
	values::Vector{Float64}
end #}}}
function ElementVector(nodes::Vector{Node})#{{{

	#Get matrix size
	nrows = NumberOfDofs(nodes,GsetEnum)

	#Initialize element matrix with zeros
	values = zeros(nrows)

	#Get dof list
	fglobaldoflist=GetGlobalDofList(nodes,nrows,FsetEnum)

	return ElementVector(nrows,fglobaldoflist,values)
end#}}}
function Base.show(io::IO, this::ElementVector)# {{{

	println(io,"ElementVector:")
	println(io,"   nrows: ",this.nrows)
	println(io,"   fglobaldoflist: ",this.fglobaldoflist)
	print(io,"   values: ")
	display(this.values)
end# }}}
