function plot_transient_movie(md,options,width,i);
%PLOT_TRANSIENT_MOVIE - plot a transient result as a movie
%   Usage:
%      plot_transient_movie(md,options,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT, PLOT_MANAGER

	%prepare subplot
	subplot(width,width,i); 

	%xlim
	if exist(options,'transient_movie_field'),
		field=getfieldvalue(options,'transient_movie_field');
	else
		error('specify transient_movie_field in options list');
	end

	%process model
	[x y z elements is2d]=processmesh(md,options);

	%loop over the time steps
	for i=1:length(md.results.transient)
		eval(['data=md.results.transient(' num2str(i) ').' num2str(field) ';']);

		%process data
		[data isongrid isquiver]=processdata(md,data,options);
		titlestring=[field ' at time ' num2str(md.results.transient(i).time) ' year'];
		plot_unit(x,y,z,elements,data,isongrid,is2d,isquiver,options)
		apply_options_movie(md,options,titlestring);
		
		if exist(options,'transient_movie_output'),
			set(gcf,'Renderer','zbuffer','color','white'); %fixes a bug on Mac OS X (not needed in future Matlab version)
			if i==1,
				%initialize images and frame
				frame=getframe(gcf);
				[images,map]=rgb2ind(frame.cdata,256,'nodither');
				images(1,1,1,length(md.results.transient))=0;
			else
				frame=getframe(gcf);
				images(:,:,1,i) = rgb2ind(frame.cdata,map,'nodither');
			end
		else
			pause(0.1)
		end
	end

	%output movie if requested.
	if exist(options,'transient_movie_output'),
		filename=getfieldvalue(options,'transient_movie_output');
		imwrite(images,map,filename,'DelayTime',getfieldvalue(options,'transient_movie_time',2),'LoopCount',inf)
	end

end %function

function apply_options_movie(md,options,titlestring)
	%apply options
	options=addfielddefault(options,'title',titlestring);
	options=addfielddefault(options,'colorbar',1);
	applyoptions(md,[],options);
end
