#Gauss class definition
struct GaussTria #{{{
	numgauss::Int64
	weights::Vector{Float64}
	coords1::Vector{Float64}
	coords2::Vector{Float64}
	coords3::Vector{Float64}
end #}}}

#Gauss constructor
function GaussTria(order::Int64) #{{{

	#=Gauss quadrature points for the triangle.
	Higher-order points from D.A. Dunavant, "High Degree Efficient
	Symmetrical Gaussian Quadrature Rules for the Triangle", IJNME,
	Vol. 21, pp. 1129-1148 (1985), as transcribed for Probe rules3.=#

	if(order==1)
		npoints = 1
		weights = [1.732050807568877]
		coords1 = [0.333333333333333]
		coords2 = [0.333333333333333]
		coords3 = [0.333333333333333]
	elseif(order==2)
		npoints = 3
		weights = [0.577350269189625; 0.577350269189625; 0.577350269189625]
		coords1 = [0.666666666666667; 0.166666666666667; 0.166666666666667]
		coords2 = [0.166666666666667; 0.666666666666667; 0.166666666666667]
		coords3 = [0.166666666666667; 0.166666666666667; 0.666666666666667]
	elseif(order==3)
		npoints = 4
		weights = [-0.974278579257493; 0.902109795608790; 0.902109795608790; 0.902109795608790]
		coords1 = [ 0.333333333333333; 0.600000000000000; 0.200000000000000; 0.200000000000000]
		coords2 = [ 0.333333333333333; 0.200000000000000; 0.600000000000000; 0.200000000000000]
		coords3 = [ 0.333333333333333; 0.200000000000000; 0.200000000000000; 0.600000000000000]
	else
		error("order ",order," not supported yet");
	end

	return GaussTria(npoints,weights,coords1,coords2,coords3)
end# }}}
function GaussTria(finiteelement::IssmEnum) #{{{

	if(finiteelement==P0Enum)
		npoints = 1
		weights = [1.]
		coords1 = [0.333333333333333]
		coords2 = [0.333333333333333]
		coords3 = [0.333333333333333]
	elseif(finiteelement==P1Enum)
			npoints = 3
			weights = 0.333333333333333*ones(3)
			coords1 = [1.; 0.; 0.]
			coords2 = [0.; 1.; 0.]
			coords3 = [0.; 0.; 1.]
	else
		error("finite element ", finiteelement," not supported yet");
	end

	return GaussTria(npoints,weights,coords1,coords2,coords3)
end# }}}
