#Tria class definition
mutable struct Tria #{{{
	sid::Int64
	pid::Int64
	#vertexids::Int64[3]
	#vertices::Vertex[3]
	vertexids::Vector{Int64}
	vertices::Vector{Vertex}
	nodeids::Vector{Int64}
	nodes::Vector{Node}
	parameters::Parameters
	inputs::Inputs
end# }}}

#Element functions
function InputCreate(element::Tria,inputs::Inputs,data::Vector{Float64},enum::IssmEnum) #{{{
	if size(data,1)==inputs.numberofelements
		SetTriaInput(inputs,enum,P0Enum,element.sid,data[element.sid])
	elseif size(data,1)==inputs.numberofvertices
		SetTriaInput(inputs,enum,P1Enum,element.vertexids,data[element.vertexids])
	else
		error("size ",size(data,1)," not supported yet");
	end
end #}}}
function Update(element::Tria,inputs::Inputs,index::Int64,md::model,finiteelement::IssmEnum) #{{{

	if finiteelement==P1Enum
		numnodes = 3
		element.nodeids    = Vector{Int64}(undef,numnodes)
		element.nodeids[1] = md.mesh.elements[index,1]
		element.nodeids[2] = md.mesh.elements[index,2]
		element.nodeids[3] = md.mesh.elements[index,3]
	else
		error("not supported yet")
	end
end #}}}
function Configure(element::Tria,nodes::Vector{Node},vertices::Vector{Vertex},parameters::Parameters,inputs::Inputs) # {{{

   #Configure vertices
   for i in 1:3
		element.vertices[i] = vertices[element.vertexids[i]]
   end

	#Configure nodes (assuming P1 finite elements)
	for i in 1:3
		element.nodes[i] = nodes[element.nodeids[i]]
	end

	#Point to real datasets
	element.parameters = parameters
	element.inputs     = inputs
	
end # }}}
function GetDofList(element::Tria,setenum::IssmEnum) # {{{

	#Define number of nodes
	numnodes = 3

	#Determine size of doflist
	numdofs = 0
	for i in 1:numnodes
		numdofs += GetNumberOfDofs(element.nodes[i],GsetEnum)
	end

	#Allocate doflist vector
	doflist = Vector{Int64}(undef,numdofs)

	#enter dofs in doflist vector
	count = 0
	for i in 1:numnodes
		count = GetDofList(element.nodes[i],doflist,count,GsetEnum)
	end

	println(doflist)
	error("S")

end # }}}
