#Test Name: PigTranFrontalforcingsrignotautoregression
import numpy as np

from calvingvonmises import *
from frontalforcingsrignotautoregression import *
from socket import gethostname
from model import *
from parameterize import *
from setflowequation import *
from setmask import *
from solve import *
from triangle import *


md = triangle(model(), '../Exp/Pig.exp', 10000)
md = setmask(md, '../Exp/PigShelves.exp', '../Exp/PigIslands.exp')
md = parameterize(md, '../Par/Pig.py')
md = setflowequation(md, 'SSA', 'all')
md.timestepping.start_time = 0
md.timestepping.time_step = 1
md.timestepping.final_time = 25

# Separate domain in 2 basins
idbasin = np.zeros((md.mesh.numberofelements,))
iid1 = np.where(md.mesh.x <= -1.6e6)[0]
for ii in range(md.mesh.numberofelements):
    for vertex in range(3):
        if md.mesh.elements[ii][vertex] - 1 in iid1:  # one vertex in basin 1; NOTE: offset because of 1-based vertex indexing
            idbasin[ii] = 1
    if idbasin[ii] == 0:  # no vertex was found in basin 1
        for vertex in range(3):
            idbasin[ii] = 2

# Calving and frontalforcings parameters
md.mask.ice_levelset = 1e4 * (md.mask.ice_levelset + 0.5)
md.calving = calvingvonmises()
md.frontalforcings = frontalforcingsrignotautoregression()
md.frontalforcings.num_basins = 2
md.frontalforcings.basin_id = idbasin - 1  # NOTE: offset because of 1-based vertex indexing
md.frontalforcings.subglacial_discharge = 0.1 * np.ones((md.mesh.numberofvertices,))
md.frontalforcings.beta0 = np.array([[0.05, 0.01]])  # intercept values of TF in basins [C]
md.frontalforcings.beta1 = np.array([[0.001, 0.0001]])  # trend values of TF in basins [C/yr]
md.frontalforcings.ar_initialtime = md.timestepping.start_time  # initial time in the AR model parameterization [yr]
md.frontalforcings.ar_order = 4
md.frontalforcings.ar_timestep = 2  # timestep of the autoregressive model [yr]
md.frontalforcings.phi = np.array([[0.1, -0.1, 0.01, -0.01], [0.2, -0.2, 0.1, 0.0]])  # autoregressive parameters

# Stochastic forcing
md.stochasticforcing.isstochasticforcing = 1
md.stochasticforcing.fields = ['FrontalForcingsRignotAutoregression']

md.stochasticforcing.covariance = 1e-4 * np.array([[1.5, 0.5], [0.5, 0.4]]) # global covariance among- and between-fields
md.stochasticforcing.randomflag = 0 # determines true/false randomness


md.transient.ismovingfront = 1
md.levelset.spclevelset = np.full((md.mesh.numberofvertices,), np.nan)
md.levelset.migration_max = 1e10

md.transient.requested_outputs = ['default', 'CalvingMeltingrate']
md.cluster = generic('name', gethostname(), 'np', 2)
md = solve(md, 'Transient')

# Fields and tolerances to track changes
field_names = [
    'Vx1', 'Vy1', 'Vel1', 'Pressure1', 'Bed1', 'Surface1', 'Thickness1', 'MaskIceLevelset1', 'CalvingMetlingRate1',
    'Vx2', 'Vy2', 'Vel2', 'Pressure2', 'Bed2', 'Surface2', 'Thickness2', 'MaskIceLevelset2', 'CalvingMetlingRate2',
    'Vx10', 'Vy10', 'Vel10', 'Pressure10', 'Bed10', 'Surface10', 'Thickness10', 'MaskIceLevelset10', 'CalvingMetlingRate10'
]
field_tolerances = [
    1e-11, 2e-11, 2e-11, 1e-12, 2e-11, 6e-12, 9e-12, 1e-12, 1e-9,
    2e-11, 1e-11, 1e-11, 9e-12, 2e-1, 2e-11, 2e-11, 1e-11, 1e-9,
    2e-10, 1e-10, 1e-10, 1e-10, 1e-10, 1e-10, 1e-10, 1e-9, 1e-9
]
field_values = [
    md.results.TransientSolution[0].Vx,
    md.results.TransientSolution[0].Vy,
    md.results.TransientSolution[0].Vel,
    md.results.TransientSolution[0].Pressure,
    md.results.TransientSolution[0].Base,
    md.results.TransientSolution[0].Surface,
    md.results.TransientSolution[0].Thickness,
    md.results.TransientSolution[0].MaskIceLevelset,
    md.results.TransientSolution[0].CalvingMeltingrate,
    md.results.TransientSolution[1].Vx,
    md.results.TransientSolution[1].Vy,
    md.results.TransientSolution[1].Vel,
    md.results.TransientSolution[1].Pressure,
    md.results.TransientSolution[1].Base,
    md.results.TransientSolution[1].Surface,
    md.results.TransientSolution[1].Thickness,
    md.results.TransientSolution[1].MaskIceLevelset,
    md.results.TransientSolution[1].CalvingMeltingrate,
    md.results.TransientSolution[9].Vx,
    md.results.TransientSolution[9].Vy,
    md.results.TransientSolution[9].Vel,
    md.results.TransientSolution[9].Pressure,
    md.results.TransientSolution[9].Base,
    md.results.TransientSolution[9].Surface,
    md.results.TransientSolution[9].Thickness,
    md.results.TransientSolution[9].MaskIceLevelset,
    md.results.TransientSolution[9].CalvingMeltingrate
]
