#Node class definition
mutable struct Node #{{{
	id::Int64
	sid::Int64
	indexingupdate::Bool
	gsize::Int64
	gdoflist::Vector{Int64}
	fdoflist::Vector{Int64}
	sdoflist::Vector{Int64}
	svalues::Vector{Float64}
end# }}}

#Node functions
function Base.show(io::IO, this::Node)# {{{

	println(io,"Node:")
	println(io,"   id:  ",this.id)
	println(io,"   sid: ",this.sid)
	println(io,"   indexingupdate: ",this.indexingupdate)
	println(io,"   gsize: ",this.gsize)
	println(io,"   gdoflist: ",this.gdoflist)
	println(io,"   fdoflist: ",this.fdoflist)
	println(io,"   sdoflist: ",this.sdoflist)
	println(io,"   svalues: ",this.svalues)
end# }}}
function ApplyConstraint(node::Node,dof::Int8,value::Float64) #{{{

	node.indexingupdate = true
	node.fdoflist[dof]  = -1
	node.sdoflist[dof]  = +1
	node.svalues[dof]   = value

end# }}}
function DistributeDofs(node::Node,setenum::IssmEnum,dofcount::Int64) #{{{

	if setenum==GsetEnum
		for i=1:node.gsize
			node.gdoflist[i] = dofcount
			dofcount += 1
		end
	elseif setenum==FsetEnum
		for i=1:node.gsize
			if  node.fdoflist[i]!=-1
				@assert node.sdoflist[i]==-1
				node.fdoflist[i] = dofcount
				dofcount += 1
			end
		end
	elseif setenum==SsetEnum
		for i=1:node.gsize
			if  node.sdoflist[i]!=-1
				@assert node.fdoflist[i]==-1
				node.sdoflist[i] = dofcount
				dofcount += 1
			end
		end
	else
		error("not supported")
	end

	return dofcount
end# }}}
function GetNumberOfDofs(node::Node,setenum::IssmEnum) #{{{

	if setenum==GsetEnum
		dofcount = node.gsize
	elseif setenum==FsetEnum
		dofcount = 0
		for i=1:node.gsize
			if  node.fdoflist[i]!=-1
				dofcount += 1
			end
		end
	elseif setenum==SsetEnum
		dofcount = 0
		for i=1:node.gsize
			if  node.sdoflist[i]!=-1
				dofcount += 1
			end
		end
	else
		error("not supported")
	end

	return dofcount

end# }}}

#Nodes functions
function RequiresDofReindexing(nodes::Vector{Node}) #{{{

	for i in 1:length(nodes)
		if nodes[i].indexingupdate
			return true
		end
	end

	return false

end# }}}
function DistributeDofs(nodes::Vector{Node},setenum::IssmEnum) #{{{

	dofcount = 1

	for i in 1:length(nodes)
		dofcount = DistributeDofs(nodes[i],setenum,dofcount)
	end


end# }}}
function NumberOfDofs(nodes::Vector{Node},setenum::IssmEnum) #{{{

	numdofs = 0
	for i in 1:length(nodes)
		numdofs += GetNumberOfDofs(nodes[i],setenum)
	end
	return numdofs

end# }}}
