#Analysis class definitions
abstract type Analysis end
struct StressbalanceAnalysis <: Analysis#{{{
end #}}}

#Stress balance analysis
function UpdateParameters(analysis::StressbalanceAnalysis,parameters::Parameters,md::model) #{{{
	AddParam(parameters,md.stressbalance.restol,StressbalanceRestolEnum)
	AddParam(parameters,md.stressbalance.reltol,StressbalanceReltolEnum)
	AddParam(parameters,md.stressbalance.abstol,StressbalanceAbstolEnum)
	AddParam(parameters,md.stressbalance.maxiter,StressbalanceMaxiterEnum)
end#}}}
function CreateNodes(analysis::StressbalanceAnalysis,nodes::Vector{Node},md::model) #{{{

	numdof = 2
	for i in 1:md.mesh.numberofvertices
		push!(nodes,Node(i,i,true,numdof,-ones(Int64,numdof), ones(Int64,numdof), -ones(Int64,numdof), zeros(numdof)))
	end
end#}}}
function UpdateElements(analysis::StressbalanceAnalysis,elements::Vector{Tria}, inputs::Inputs, md::model) #{{{

	#Provide node indices to element
	for i in 1:md.mesh.numberofvertices
		Update(elements[i],inputs,i,md,P1Enum)
	end

	#Add necessary inputs to perform this analysis
	FetchDataToInput(md,inputs,elements,md.materials.rheology_B,MaterialsRheologyBEnum)
	FetchDataToInput(md,inputs,elements,md.geometry.thickness,ThicknessEnum)
	FetchDataToInput(md,inputs,elements,md.geometry.surface,SurfaceEnum)
	FetchDataToInput(md,inputs,elements,md.geometry.base,BaseEnum)
	FetchDataToInput(md,inputs,elements,md.initialization.vx./md.constants.yts,VxEnum)
	FetchDataToInput(md,inputs,elements,md.initialization.vy./md.constants.yts,VyEnum)

end#}}}
function CreateConstraints(analysis::StressbalanceAnalysis,constraints::Vector{Constraint},md::model) #{{{

	#load constraints from model
	spcvx = md.stressbalance.spcvx
	spcvy = md.stressbalance.spcvy

	count = 1
	for i in 1:md.mesh.numberofvertices
		if ~isnan(spcvx[i])
			push!(constraints,Constraint(count,i,1,spcvx[i]))
			count+=1
		end
		if ~isnan(spcvy[i])
			push!(constraints,Constraint(count,i,2,spcvy[i]))
			count+=1
		end
	end

end#}}}
function GetSolutionFromInputs(analysis::StressbalanceAnalysis,ug::Vector{Float64},element::Tria) #{{{
	error("STOP")
end#}}}

function Core(analysis::StressbalanceAnalysis,femmodel::FemModel)# {{{

	#Fetch parameters relevant to solution sequence
	maxiter = FindParam(femmodel.parameters,StressbalanceMaxiterEnum)
	restol  = FindParam(femmodel.parameters,StressbalanceRestolEnum)
	reltol  = FindParam(femmodel.parameters,StressbalanceReltolEnum)
	abstol  = FindParam(femmodel.parameters,StressbalanceAbstolEnum)

	solutionsequence_nonlinear(femmodel,analysis,maxiter,restol,reltol,abstol)
	error("STOP")

end #}}}


function solutionsequence_nonlinear(femmodel::FemModel,analysis::Analysis,maxiter::Int64,restol::Float64,reltol::Float64,abstol::Float64) # {{{

	#Initialize number of iterations
	count = 0
	converged = false

	#Get existing solution
	ug = GetSolutionFromInputsx(analysis,femmodel)

	#Loop until we reach convergence
	while(~converged)

		error("not implemented yet")

		#Increase count
		count += 1
		if(count>maxiter)
			println("   maximum number of nonlinear iterations (",maxiter,") exceeded")
			converged = true
		end
	end

	error("STOP")

end# }}}
