#Node class definition
mutable struct Node #{{{
	id::Int64
	sid::Int64
	indexingupdate::Bool
	gsize::Int64
	gdoflist::Vector{Int64}
	fdoflist::Vector{Int64}
	sdoflist::Vector{Int64}
	svalues::Vector{Float64}
end# }}}

#Node functions
function Base.show(io::IO, this::Node)# {{{

	println(io,"Node:")
	println(io,"   id:  ",this.id)
	println(io,"   sid: ",this.sid)
	println(io,"   indexingupdate: ",this.indexingupdate)
	println(io,"   gsize: ",this.gsize)
	println(io,"   gdoflist: ",this.gdoflist)
	println(io,"   fdoflist: ",this.fdoflist)
	println(io,"   sdoflist: ",this.sdoflist)
	println(io,"   svalues: ",this.svalues)
end# }}}
function ApplyConstraint(node::Node,dof::Int8,value::Float64) #{{{

	node.indexingupdate = true
	node.fdoflist[dof]  = -1
	node.sdoflist[dof]  = +1
	node.svalues[dof]   = value

end# }}}
