#Input class definition
abstract type Input end
struct BoolInput <: Input#{{{
	enum::IssmEnum
	values::Matrix{Bool}
end# }}}
struct IntInput <: Input#{{{
	enum::IssmEnum
	values::Matrix{Int64}
end# }}}
struct ElementInput <: Input#{{{
	enum::IssmEnum
	interp::IssmEnum
	values::Vector{Float64}
end# }}}

#Inputs dataset definition
mutable struct Inputs #{{{
	numberofelements::Int64
	numberofvertices::Int64
	lookup::Dict{IssmEnum,Input}
end# }}}

#Inputs functions
function SetInput(inputs::Inputs,enum::IssmEnum,index::Int64,value::Bool) #{{{

	#Does this input exist
	if !haskey(inputs.lookup,enum)
		#it does not exist yet, we need to create it...
		@assert inputs.numberofelements > 0
		input = BoolInput(enum,zeros(Bool,inputs.numberofelements))
		inputs.lookup[enum] = BoolInput(enum,zeros(Bool,inputs.numberofelements))
	end

	#Get this input and check type
	input = inputs.lookup[enum]
	if typeof(input)!=BoolInput error("not consistent") end

	#set value
	@assert index>0 && index<=inputs.numberofelements
	input.values[index] = value
end#}}}
function SetTriaInput(inputs::Inputs,enum::IssmEnum,interp::IssmEnum,index::Int64,value::Float64) #{{{

	#Does this input exist
	if !haskey(inputs.lookup,enum)
		#it does not exist yet, we need to create it...
		@assert inputs.numberofelements > 0
		if interp==P0Enum
			inputs.lookup[enum] = ElementInput(enum,interp,zeros(inputs.numberofelements))
		elseif interp==P1Enum
			inputs.lookup[enum] = ElementInput(enum,interp,zeros(inputs.numberofvertices))
		else
			error("not supported yet")
		end
	end

	#Get this input and check type
	input = inputs.lookup[enum]
	if typeof(input)!=ElementInput error("input type not consistent") end
	if interp!=input.interp        error("input interpolations not consistent") end

	#set value
	input.values[index] = value
end#}}}
function SetTriaInput(inputs::Inputs,enum::IssmEnum,interp::IssmEnum,indices::Vector{Int64},values::Vector{Float64}) #{{{

	#Does this input exist
	if !haskey(inputs.lookup,enum)
		#it does not exist yet, we need to create it...
		@assert inputs.numberofvertices>0
		if interp==P1Enum
			inputs.lookup[enum] = ElementInput(enum,interp,zeros(inputs.numberofvertices))
		else
			error("not supported yet")
		end
	end

	#Get this input and check type
	input = inputs.lookup[enum]
	if typeof(input)!=ElementInput error("input type not consistent") end
	if interp!=input.interp        error("input interpolations not consistent") end

	#set value
	input.values[indices] = values
end#}}}
