/*!\file: randomgenerator
 * \brief random number generating functions
 */

#include <iostream>
#include "./randomgenerator.h"
#include <cmath>
#include <chrono>

#undef M_PI
#define M_PI 3.141592653589793238462643

namespace rnd{

  /* Linear congruential engine */

  linear_congruential_engine::linear_congruential_engine(){/*{{{*/

      pseed = new unsigned int;
			*pseed = std::chrono::steady_clock::now().time_since_epoch()/std::chrono::milliseconds(1);
      a = 1103515245;		       // BSD Formula
      c = 12345;					     // BSD Formula
      m = 2147483648;			     // BSD Formula
			return;
	}/*}}}*/

  linear_congruential_engine::linear_congruential_engine(unsigned int _a, unsigned int _b, unsigned int _m){/*{{{*/

      pseed = new unsigned int;
			*pseed = std::chrono::steady_clock::now().time_since_epoch()/std::chrono::milliseconds(1);
      a = _a;
      c = _b;
      m = _m;
			return;
	}/*}}}*/

  linear_congruential_engine::~linear_congruential_engine(){}

  unsigned int linear_congruential_engine::get_m() { return m; }

  void linear_congruential_engine::seed( int s ) {
      if(s<0)
        *pseed = std::chrono::steady_clock::now().time_since_epoch()/std::chrono::milliseconds(1);
      else
        *pseed = (unsigned) s;
  }

  unsigned int linear_congruential_engine::generator(){
    *pseed = ( a * *pseed + c ) % m ;
    return *pseed;
  }

  /* Uniform distribution */

	uniform_distribution::uniform_distribution(){/*{{{*/
			a = 0.0;
			b = 1.0;
			return;
	}
	/*}}}*/

	uniform_distribution::uniform_distribution(double _a,double _b){/*{{{*/
			a = _a;
			b = _b;
			return;
	}
	/*}}}*/

	uniform_distribution::~uniform_distribution(){}

	double uniform_distribution::generator(rnd::linear_congruential_engine random_engine) {
			return (b-a)*(double) random_engine.generator()/ random_engine.get_m() + a;
	}

  /* Normal distribution */

	normal_distribution::normal_distribution(){/*{{{*/
			mean   = 0;
			sdev  = 1.0;
			return;
	}
	/*}}}*/

	normal_distribution::normal_distribution(double m,double s){/*{{{*/
			mean   = m;
			sdev  = s;
			return;
	}
	/*}}}*/

	normal_distribution::~normal_distribution(){}

	double normal_distribution::generator(rnd::linear_congruential_engine random_engine){/*{{{*/

			rnd::uniform_distribution	unifdistri;

			double u1 = unifdistri.generator(random_engine);
			double u2 = unifdistri.generator(random_engine);

			double R = sqrt(-2*log(u1));
			double theta = 2*M_PI*u2;

			return mean + sdev * (R*cos(theta));

	}
	/*}}}*/

}
