/*!\file: randomgenerator.h
 * \brief prototypes for randomgenerator.h
 */

#ifndef _RANDOMGENERATOR_H_
#define _RANDOMGENERATOR_H_

#undef M_PI
#define M_PI 3.141592653589793238462643

namespace rnd{

  class linear_congruential_engine
  {
    private:
      unsigned int a;
      unsigned int c;
      unsigned int m;
      unsigned int *pseed;

    public:

      /*constructors, destructors: */
      linear_congruential_engine();
      linear_congruential_engine(unsigned int _a, unsigned int _b, unsigned int _m);
      ~linear_congruential_engine();

      unsigned int get_m();
      void seed( int s );
      unsigned int generator();

  };

  class uniform_distribution
  {

    private:
      double a;  // lower bound of range
      double b;  // upper bound of range

    public:

      /*constructors, destructors: */
      uniform_distribution();
      uniform_distribution(double _a,double _b);
      ~uniform_distribution();

      double generator(rnd::linear_congruential_engine random_engine);

  };

  class normal_distribution
  {

    private:
      double mean;
      double sdev;

    public:

      /*constructors, destructors: */
      normal_distribution();
      normal_distribution(double m,double s);
      ~normal_distribution();

      double generator(rnd::linear_congruential_engine random_engine);

  };


}

#endif //* _RANDOMGENERATOR_H_ */
