/*!\file: randomgenerator.h
 * \brief prototypes for randomgenerator.h
 */

#ifndef _RANDOMGENERATOR_H_
#define _RANDOMGENERATOR_H_

#undef M_PI
#define M_PI 3.141592653589793238462643

namespace rnd{

  class uniform_distribution
  {

    private:
      int a;
      int c;
      unsigned int m;
      unsigned _seed;
      double lbound;
      double ubound;

    public:

      /*constructors, destructors: */
      uniform_distribution();
      uniform_distribution(double a_1,double a_2);
      ~uniform_distribution();

      void seed( unsigned int s );
      unsigned int get_seed();
      double generator();

  };

  class normal_distribution
  {

    private:
      unsigned _seed;
      double mean;
      double sdev;

    public:

      /*constructors, destructors: */
      normal_distribution();
      normal_distribution(double m,double s);
      ~normal_distribution();

      void seed( unsigned int s );
      double generator();

  };

}

#endif //ifndef _RANDOMGENERATOR_H_
