/*!\file: randomgenerator
 * \brief random number generating functions
 */

#include <iostream>
#include "./randomgenerator.h"
#include <cmath>


#undef M_PI
#define M_PI 3.141592653589793238462643

namespace rnd{

	uniform_distribution::uniform_distribution(){/*{{{*/

			a   = 1103515245; 	// BSD Formula
			c  = 12345;					// BSD Formula
			m = 2147483648;			// BSD Formula
			_seed = 0;
			lbound = 0.0;
			ubound = 1.0;
			return;
	}
	/*}}}*/
	uniform_distribution::uniform_distribution(double lower,double upper){/*{{{*/

			a   = 1103515245;		// BSD Formula
			c  = 12345;					// BSD Formula
			m = 2147483648;			// BSD Formula
			_seed = 0;
			lbound = lower;
			ubound = upper;
			return;
	}
	/*}}}*/
	uniform_distribution::~uniform_distribution(){}
	void uniform_distribution::seed( unsigned int s ) { _seed = s; }
	unsigned int uniform_distribution::get_seed() { return _seed; }
	double uniform_distribution::generator() {
			_seed = ( a * _seed + c ) % m ;
			return (ubound-lbound)*(double) _seed/ m + lbound;
	}


	normal_distribution::normal_distribution(){/*{{{*/

			_seed = 0;
			mean   = 0;
			sdev  = 1.0;
			return;
	}
	/*}}}*/
	normal_distribution::normal_distribution(double m,double s){/*{{{*/

			_seed = 0;
			mean   = m;
			sdev  = s;
			return;
	}
		/*}}}*/
	normal_distribution::~normal_distribution(){}
	void normal_distribution::seed( unsigned int s ) { _seed = s; }
	double normal_distribution::generator(){/*{{{*/

			rnd::uniform_distribution	unifdistri;
			unifdistri.seed(_seed);

			double u1 = unifdistri.generator();
			double u2 = unifdistri.generator();

			double R = sqrt(-2*log(u1));
			double theta = 2*M_PI*u2;

			seed(unifdistri.get_seed());

			return mean + sdev * (R*cos(theta));

	}
	/*}}}*/

}
