/*!\file: randomgenerator
 * \brief random number generating functions
 */

#include <iostream>
#include "./randomgenerator.h"
#include <cmath>


#undef M_PI
#define M_PI 3.141592653589793238462643

rnd_uniform_distribution::rnd_uniform_distribution(){/*{{{*/

		a   = 1103515245; 	// BSD Formula
		c  = 12345;					// BSD Formula
		m = 2147483648;			// BSD Formula
		_seed = 0;
		lbound = 0.0;
		ubound = 1.0;
		return;
}
/*}}}*/
rnd_uniform_distribution::rnd_uniform_distribution(double lower,double upper){/*{{{*/

		a   = 1103515245;		// BSD Formula
		c  = 12345;					// BSD Formula
		m = 2147483648;			// BSD Formula
		_seed = 0;
		lbound = lower;
		ubound = upper;
		return;
}
/*}}}*/
rnd_uniform_distribution::~rnd_uniform_distribution(){}
void rnd_uniform_distribution::seed( unsigned int s ) { _seed = s; }
unsigned int rnd_uniform_distribution::get_seed() { return _seed; }
double rnd_uniform_distribution::generator() {
		_seed = ( a * _seed + c ) % m ;
		return (ubound-lbound)*(double) _seed/ m + lbound;
}


rnd_normal_distribution::rnd_normal_distribution(){/*{{{*/

		_seed = 0;
		mean   = 0;
		sdev  = 1.0;
		return;
}
/*}}}*/
rnd_normal_distribution::rnd_normal_distribution(double m,double s){/*{{{*/

		_seed = 0;
		mean   = m;
		sdev  = s;
		return;
}
	/*}}}*/
rnd_normal_distribution::~rnd_normal_distribution(){}
void rnd_normal_distribution::seed( unsigned int s ) { _seed = s; }
double rnd_normal_distribution::generator(){/*{{{*/

		rnd_uniform_distribution	unifdistri;
		unifdistri.seed(_seed);

		double u1 = unifdistri.generator();
		double u2 = unifdistri.generator();

		double R = sqrt(-2*log(u1));
		double theta = 2*M_PI*u2;

		seed(unifdistri.get_seed());

		return mean + sdev * (R*cos(theta));

}
/*}}}*/
