/*!\file: randomgenerator.h
 * \brief prototypes for randomgenerator.h
 */

#ifndef _RANDOMGENERATOR_H_
#define _RANDOMGENERATOR_H_

#undef M_PI
#define M_PI 3.141592653589793238462643

class rnd_uniform_distribution
{

  private:
    int a;
    int c;
    unsigned int m;
    unsigned _seed;
    double lbound;
    double ubound;

  public:

    /*constructors, destructors: */
    rnd_uniform_distribution();
    rnd_uniform_distribution(double a_1,double a_2);
    ~rnd_uniform_distribution();

    void seed( unsigned int s );
    unsigned int get_seed();
    double generator();

};

class rnd_normal_distribution
{

  private:
    unsigned _seed;
    double mean;
    double sdev;

  public:

    /*constructors, destructors: */
    rnd_normal_distribution();
    rnd_normal_distribution(double m,double s);
    ~rnd_normal_distribution();

    void seed( unsigned int s );
    double generator();

};

#endif //ifndef _RANDOMGENERATOR_H_
