/*!\file: randomgenerator.h
 * \brief prototypes for randomgenerator.h
 */

#ifndef _RANDOMGENERATOR_H_
#define _RANDOMGENERATOR_H_

#undef M_PI
#define M_PI 3.141592653589793238462643

class uniform_distribution_rnd
{

    private:

      unsigned int a;       //multiplier of the linear congruential generator
      unsigned int c;       //increment of the linear congruential generator
      unsigned int m;       // modulo of the linear congruential generator
      unsigned int _seed;   // seed value
      double lbound;        // lower bound of uniform distribution
      double ubound;        // upper bound of uniform distribution

    public:

      /*constructors, destructors: */
      uniform_distribution_rnd();
      uniform_distribution_rnd(double a_1, double a_2);
      ~uniform_distribution_rnd();

      void seed( unsigned int s );
      unsigned int get_seed();
      double generator();

};

class normal_distribution_rnd
{

    private:
      unsigned int _seed; // seed value
      double mean;        // mean value
      double sdev;        // standard deviation

    public:

      /*constructors, destructors: */
      normal_distribution_rnd();
      normal_distribution_rnd(double m,double s);
      ~normal_distribution_rnd();

      void seed( unsigned int s );
      double generator();

};

#endif //ifndef _RANDOMGENERATOR_H_
