/*!\file: randomgenerator
 * \brief random number generating functions
 */

#include <iostream>
#include "./randomgenerator.h"

#undef M_PI
#define M_PI 3.141592653589793238462643


uniform_distribution_rnd::uniform_distribution_rnd(){/*{{{*/

		a   = 1103515245; 	// BSD Formula
		c  = 12345;					// BSD Formula
		m = 2147483648;			// BSD Formula
		_seed = 0;
		lbound = 0.0;
		ubound = 1.0;
		return;
}
	/*}}}*/
uniform_distribution_rnd::uniform_distribution_rnd(double lower,double upper){/*{{{*/

		a   = 1103515245;		// BSD Formula
		c  = 12345;					// BSD Formula
		m = 2147483648;			// BSD Formula
		_seed = 0;
		lbound = lower;
		ubound = upper;
		return;
}
	/*}}}*/
uniform_distribution_rnd::~uniform_distribution_rnd(){}
void uniform_distribution_rnd::seed( unsigned int s ) { _seed = s; }
unsigned int uniform_distribution_rnd::get_seed() { return _seed; }
double uniform_distribution_rnd::generator() {
		_seed = ( a * _seed + c ) % m ;
		return (ubound-lbound)*(double) _seed/ m + lbound;
}


normal_distribution_rnd::normal_distribution_rnd(){/*{{{*/

		_seed = 0;
		mean   = 0;
		sdev  = 1.0;
		return;
}
/*}}}*/
normal_distribution_rnd::normal_distribution_rnd(double m,double s){/*{{{*/

		_seed = 0;
		mean   = m;
		sdev  = s;
		return;
}
	/*}}}*/
normal_distribution_rnd::~normal_distribution_rnd(){}
void normal_distribution_rnd::seed( unsigned int s ) { _seed = s; }
double normal_distribution_rnd::generator(){/*{{{*/

		uniform_distribution_rnd unifdistri;
		unifdistri.seed(_seed);

		double u1 = unifdistri.generator();
		double u2 = unifdistri.generator();

		double R = sqrt(-2*log(u1));
		double theta = 2*M_PI*u2;

		seed(unifdistri.get_seed());

		return mean + sdev * (R*cos(theta));

	}
	/*}}}*/
