/*!\file: randomgenerator.h
 * \brief prototypes for randomgenerator.h
 */

#ifndef _RANDOMGENERATOR_H_
#define _RANDOMGENERATOR_H_

#undef M_PI
#define M_PI 3.141592653589793238462643

class uniform_distribution_rnd
{

  private:

    unsigned int a;
    unsigned int c;
    unsigned int m;
    unsigned _seed;
    double a1;
    double a2;

    int drnd() { return( _seed = ( a * _seed + c ) % m ); }

  public:

    /*constructors, destructors: */
    uniform_distribution_rnd();
    uniform_distribution_rnd(double a_1, double a_2);
    ~uniform_distribution_rnd();

    void seed( unsigned int s ) { _seed = s; }
    unsigned int get_seed() { return _seed; }
    double rnd() { return (a2-a1)*(double) drnd()/ m + a1; }

};

class normal_distribution_rnd
{

  private:
    unsigned _seed;
    double mean;
    double sdev;

  public:
    normal_distribution_rnd() : _seed( 0 ), mean( 0), sdev(1.0) {}
    normal_distribution_rnd(double m,double s) : _seed( 0 ), mean( m ), sdev(s) {}
    void seed( unsigned int s ) { _seed = s; }
    double rnd();

};

#endif //ifndef _RANDOMGENERATOR_H_
