import os
import MatlabFuncs as m


def SetMLHOBC(md):
    """
    SETMLHOBC - Create the boundary conditions for stressbalance for MLHO: VxBase, VyBase, VxShear, VyShear

       Usage:
          md = SetIceShelfBC(md, varargin)

       Example:
          md = SetIceShelfBC(md)

    """

    #node on Dirichlet (boundary and ~icefront)
    md.stressbalance.spcvx_base = md.stressbalance.spcvx
    md.stressbalance.spcvy_base = md.stressbalance.spcvy
    md.stressbalance.spcvx_shear = float('nan') * md.stressbalance.spcvx
    md.stressbalance.spcvy_shear = float('nan') * md.stressbalance.spcvy 
