function md=SetMLHOBC(md)
%SETMLHOBC - Create the boundary conditions for stressbalance for MLHO: VxBase, VyBase, VxShear, VyShear
%
%   Usage:
%      md=SetMLHOBC(md)
%


%node on Dirichlet
if md.flowequation.isMLHO
	md.stressbalance.spcvx_base=md.stressbalance.spcvx;
	md.stressbalance.spcvy_base=md.stressbalance.spcvy;

	md.stressbalance.spcvx_shear=NaN*ones(size(md.stressbalance.spcvx_base));
	md.stressbalance.spcvy_shear=NaN*ones(size(md.stressbalance.spcvy_base));
end
