#utils
function issmdir() #{{{
	issmdir = ENV["ISSM_DIR"]

	if isempty(issmdir)
		error("Could not determine the location of ISSM")
	else
		return issmdir
	end
end#}}}
function archread(filename::String,variablename::String) #{{{

	#initialize variables
	found = false

	#open file
	output = open(filename, "r") do f

		while !eof(f)
			reclen  = bswap(read(f, Int32))
			rectype = bswap(read(f, Int32))
			if rectype!=1
				error("Expected variable of type string")
			else
				fieldname_length = bswap(read(f, Int32))
				field_name = String(read(f, fieldname_length))
			end
			rec_length = bswap(read(f, Int32))
			field_type = bswap(read(f, Int32))
			if field_type==2
				data = bswap(read(f, Float64))
			elseif field_type==3
				rows = bswap(read(f, Int32))
				cols = bswap(read(f, Int32))
				data = reinterpret(Float64, read(f, sizeof(Float64)*rows*cols))
				data .= ntoh.(data)
				data = reshape(data, (rows,cols))
				data = collect(data)
				if cols == 1
					data = vec(data)
				end
			else
				error("Error: Encountered invalid field type when reading data.")
			end

			if field_name == variablename
				found = true
				return data
			end
		end
	end

	return output
end# }}}
function InterpFromMeshToMesh2d(index::Array,x::Vector,y::Vector,data::Vector,xout::Vector,yout::Vector) #{{{
	#prepare input arrays
	nods = Cint(length(x))
	nels = Cint(size(index,1))
	nods_interp = Cint(length(xout))
	Cindex=Array{Cint,1}(undef,length(index))
	for i in 1:size(index,1)
		for j in 1:3
			Cindex[(i-1)*3+j] = Int32(index[i,j])
		end
	end
	Cx    = Array{Cdouble,1}(undef,nods)
	Cy    = Array{Cdouble,1}(undef,nods)
	Cdata = Array{Cdouble,1}(undef,nods)
	for i in 1:nods
		Cx[i]    = x[i]
		Cy[i]    = y[i]
		Cdata[i] = data[i]
	end
	Cxout = Array{Cdouble,1}(undef,nods_interp)
	Cyout = Array{Cdouble,1}(undef,nods_interp)
	for i in 1:nods_interp
		Cxout[i] = xout[i]
		Cyout[i] = yout[i]
	end

	Cdataout = Vector{Float64}(undef,nods_interp)

	#This is not working....
	rc=ccall( (:InterpFromMeshToMesh2dx,"libISSMCore"),
				Cint, (Ptr{Ptr{Cdouble}},Ptr{Cint}, Ptr{Cdouble}, Ptr{Cdouble}, Cint, Cint, Ptr{Cdouble}, Cint, Cint, Ptr{Cdouble}, Ptr{Cdouble}, Cint),
				Ref(Ref(Cdataout)), Ref(Cindex), Ref(Cx), Ref(Cy), nods, nels,
				Ref(Cdata), nods, 1, Ref(Cxout), Ref(Cyout), nods_interp)

	#Process output
	dataout = Vector{Float64}(undef,nods_interp)
	for i in 1:nods_interp
		dataout[i] = Cdataout[i]
	end

	return dataout
end #}}}
function solve(md::model,solution::String) #{{{

	if solution=="sb" || solution=="Stressbalance"
		solutionstring = "StressbalanceSolution"
	else
		error("solutionstring "*solution*" not supported!");
	end

	IssmCore(md)

	return md
end #}}}
