
#import ColorSchemes.leonardo
#include("issm.jl")

using GLMakie

function plotmodel(md::model)

	elementcolor = :yellow
	vertexcolor  = :black
	facetcolor   = :blue
	showvertices = true
	showfacets   = true

	scene = Makie.mesh( [md.mesh.x md.mesh.y], md.mesh.elements, shading = false, color = elementcolor)

	if showvertices
		Makie.scatter!( [md.mesh.x md.mesh.y], markersize = 4, color = vertexcolor)
	end


	return scene
end
