using Printf

#Define classes used by model struct
abstract type AbstractMesh end
mutable struct Mesh2dTriangle <: AbstractMesh
	numberofvertices::Int32
	numberofelements::Int32
	x::Vector{Float64}
	y::Vector{Float64}
	elements::Matrix{Int32}
end
function Mesh2dTriangle() #{{{
	return Mesh2dTriangle( 0, 0, Vector{Float64}(undef,0), Vector{Float64}(undef, 0), Matrix{Int32}(undef, 0, 0))
end# }}}
mutable struct Mesh3dPrism{T} <: AbstractMesh
	numberofvertices::Int32
	numberofelements::Int32
	numberoflayers::Int32
	x::Vector{Float64}
	y::Vector{Float64}
	z::Vector{Float64}
	elements::Matrix{Int32}
end
function Mesh3dPrism() #{{{
	return Mesh3dPrism( 0, 0, 0, Vector{Float64}(undef,0), Vector{Float64}(undef,0), Vector{Float64}(undef,0), Matrix{Int32}(undef, 0, 0))
end# }}}
mutable struct Geometry
	surface::Vector{Float64}
	base::Vector{Float64}
	thickness::Vector{Float64}
	bed::Vector{Float64}
end
function Geometry() #{{{
	return Geometry( Vector{Float64}(undef,0), Vector{Float64}(undef,0), Vector{Float64}(undef,0), Vector{Float64}(undef,0))
end# }}}

mutable struct model
	mesh::AbstractMesh
	geometry::Geometry
end
function model() #{{{
	return model(Mesh2dTriangle(),Geometry())
end#}}}
function Base.show(io::IO, md::model)# {{{

	compact = get(io, :compact, false)

	println(io,"Model:")
	@printf "%19s: %-22s -- %s\n" "mesh" typeof(md.mesh) "mesh properties"
	@printf "%19s: %-22s -- %s\n" "geometry" typeof(md.geometry) "surface elevation, bedrock topography, ice thickness,..."

end# }}}

# Probably actually want something more like:
# function solve(mesh::AbstractMesh, data::AbstractDataset)
#     do_something_with_mesh(mesh) # This will dispatch
#     do_something_with_data(data) # This will dispatch
#     # do something
# end
