abstract type AbstractMesh end

struct Mesh2dTriangle <: AbstractMesh
	numberofvertices::Int32
	numberofelements::Int32
	x::Vector{Float64}
	y::Vector{Float64}
	elements::Matrix{Int32}
end

struct Mesh3dPrism{T} <: AbstractMesh
	numberofvertices::Int32
	numberofelements::Int32
	numberoflayers::Int32
	x::Vector{Float64}
	y::Vector{Float64}
	z::Vector{Float64}
	elements::Matrix{Int32}
end

struct Geometry
	surface::Vector{Float64}
	base::Vector{Float64}
	thickness::Vector{Float64}
	bed::Vector{Float64}
end

function configure(;
        MeshType = Mesh2dTriangle,
		  meshnbv = 0,
		  meshnbe = 0,
        meshx = [NaN],
        meshy = [NaN],
		  meshel = [0],
        GeometryType = Geometry,
		  geos = [NaN],
		  geob1 = [NaN],
		  geoh = [NaN],
		  geob2 = [NaN],
    )

	mesh = MeshType(meshnbv,meshnbe,meshx,meshy,meshel)
	geometry = Geometry(geos,geob1,geoh,geob2)

    return (mesh = mesh, geometry = geometry)
end

solve(model::NamedTuple) = solve(model.mesh, model.geometry)

function solve(mesh::Mesh2dTriangle, geometry::Geometry)
    println("Solving with triangular mesh, ... data, ...")
    # do something
end
function solve(mesh::Mesh3dPrism, geometry::Geometry)
    println("Solving with rectangular mesh, ... data, ...")
    # do something
end

# Probably actually want something more like:
# function solve(mesh::AbstractMesh, data::AbstractDataset)
#     do_something_with_mesh(mesh) # This will dispatch
#     do_something_with_data(data) # This will dispatch
#     # do something
# end

function remake(model::NamedTuple;
        MeshType = typeof(model.mesh),
		  meshnbv = model.mesh.nbv,
		  meshnbe = model.mesh.nbe,
        meshx = model.mesh.x,
        meshy = model.mesh.y,
		  meshel = model.mesh.elements,
        surface = model.geometry.surface,
        base = model.geometry.base,
		  thickness = model.geometry.thickness,
		  bed = model.geometry.bed,
    )

    mesh = MeshType(meshnbv, meshnbe, meshx, meshy, meshel)
	 geometry = geometry(surface, base, thickness, bed)

    return (mesh = mesh, geometry = geometry)
end

function remesh(model::NamedTuple;
        MeshType = Mesh2dTriangle,
        meshx = rand(1000),
        meshy = rand(1000)
    )

    new_mesh = MeshType(meshx, meshy)
    return (mesh = new_mesh, data = model.data)
end

## --- Try it out

# Just use default parameters
model = configure()
solve(model)
## --- Try it out

# Actually specify some relevant parameters
model = configure(
    MeshType = Mesh3dPrism,
    foo = rand(10000),
    bar = rand(1000,1000),
    baz = randn(1000,1000)
)
solve(model)
