#!/bin/bash
set -eu


## Constants
#
VER="3.15.0"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://ftp.mcs.anl.gov/pub/petsc/release-snapshots/petsc-3.15.0.tar.gz' 'petsc-3.15.0.tar.gz'

# Unpack source
tar -zxvf petsc-3.15.0.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to $PETSC_DIR
mv petsc-3.15.0/* src/
rm -rf petsc-3.15.0


# Configure
#
# NOTE: Based on /nasa/petsc/3.7.5/intel_mpt/lib/petsc/conf/petscvariables; look for CONFIGURE_OPTIONS
#
cd src
./config/configure.py \
	--prefix="${ISSM_DIR}/externalpackages/petsc/install" \
	--PETSC_DIR="${ISSM_DIR}/externalpackages/petsc/src" \
	--with-cc=icc --with-cxx=icpc --with-fc=ifort --with-f77=ifort\
	-COPTFLAGS="-g -O3 -axCORE-AVX2,AVX -xSSE4.2" -CXXOPTFLAGS="-g -O3 -axCORE-AVX2,AVX -xSSE4.2" -FOPTFLAGS="-g -O3 -axCORE-AVX2,AVX -xSSE4.2" \
	--with-blas-lapack-dir="/nasa/intel/Compiler/2016.2.181/compilers_and_libraries_2016.2.181/linux/mkl/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1

# Compile and install
make
make install
