#!/bin/bash
set -eu


# Constants
#
VER="8.1.0"

PREFIX="${ISSM_DIR}/externalpackages/proj/install" # Set to location where external package should be installed

## Environment
#
export CC=mpicc
export CXX=mpicxx

# Cleanup
rm -rf ${PREFIX} src
mkdir -p ${PREFIX} src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/proj-${VER}.tar.gz" "proj-${VER}.tar.gz"

# Unpack source
tar -zxvf proj-${VER}.tar.gz

# Move source into 'src' directory
mv proj-${VER}/* src
rm -rf proj-${VER}

# Configure
cd src
./configure \
	--prefix="${PREFIX}" \
	--disable-dependency-tracking \
	--enable-fast-install

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
