#!/bin/bash
set -eu


# NOTE: There is a single difference between the Linux and macOS 
#		configurations, which is the addition of the -static-libgfortran 
#		option to FFLAGS on the macOS static configurations. For the sake of 
#		consistency, we maintain separate files for each, respective Linux and 
#		macOS configuration.

# Constants
VER="3.14.0"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://ftp.mcs.anl.gov/pub/petsc/release-snapshots/petsc-lite-${VER}.tar.gz" "petsc-${VER}.tar.gz"

# Unpack source
tar -zxvf petsc-${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv petsc-${VER}/* src/
rm -rf petsc-${VER}

# Configure
cd src
./config/configure.py \
	COPTFLAGS="-g -O3" CXXOPTFLAGS="-g -O3" FOPTFLAGS="-g -O3" \
	--prefix="${ISSM_DIR}/externalpackages/petsc/install" \
	--PETSC_DIR="${ISSM_DIR}/externalpackages/petsc/src" \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-pic=1 \
	--with-blas-lapack-dir="/usr/local/intel/2020/compilers_and_libraries_2020.0.166/linux/mkl/" \
	--with-cc="/usr/local/sgi/mpi/mpt-2.17/bin/mpicc" \
	--with-cxx="/usr/local/sgi/mpi/mpt-2.17/bin/mpicxx" \
	--with-fc="/usr/local/sgi/mpi/mpt-2.17/bin/mpif90" \
	--known-mpi-shared-libraries=1 \
	--known-64-bit-blas-indices \
	--known-mpi-long-double=1 \
	--known-mpi-int64_t=1 \
	--known-mpi-c-double-complex=1 \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-scalapack=1 \
	--download-mumps=1

# Compile and install
make
make install
