function [xout,yout] = CoordTransform(xin,yin,projin,projout)
%COORDTRANSFORM - use PROJ to transform coordinates
%
%   Usage:
%      [xout,yout] = CoordTransform(xin,yin,projin,projout)
%
%   xin,  yin : input coordinates
%   xout, yout: output coordinates (in new projection)
%   projin,projout: input/output projection string (PROJ)
%
%   Example of Projections:
%      
%   lat/lon = '+init=epsg:4326'
%   lat/lon = '+proj=longlat +datum=WGS84'
%   
%   ll2xy default equivalent (uses with Hugues Ellispoid S)
%   Greenland = '+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.448564109 +units=m +no_defs'
%   Antarctica = '+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.448564109 +units=m +no_defs'
%   Bamber Greenland = '+proj=stere +lat_0=90 +lat_ts=71 +lon_0=-39 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs'
%
%   for latitude/longitude, x is longitude and y latitude and the angles are in rad
%
%   This function will only work of PROJ has been installed in externalpackages

% Check usage
if nargin~=4
	help CoordTransform
	error('Wrong usage (see above)');
end

% Call mex module
[xout, yout] = CoordTransform_matlab(xin,yin,projin,projout);

