/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	ParametersSTARTEnum,
	/*Parameters{{{*/
	AdolcParamEnum,
	AmrDeviatoricErrorGroupThresholdEnum,
	AmrDeviatoricErrorMaximumEnum,
	AmrDeviatoricErrorResolutionEnum,
	AmrDeviatoricErrorThresholdEnum,
	AmrErrEnum,
	AmrFieldEnum,
	AmrGradationEnum,
	AmrGroundingLineDistanceEnum,
	AmrGroundingLineResolutionEnum,
	AmrHmaxEnum,
	AmrHminEnum,
	AmrIceFrontDistanceEnum,
	AmrIceFrontResolutionEnum,
	AmrKeepMetricEnum,
	AmrLagEnum,
	AmrLevelMaxEnum,
	AmrRestartEnum,
	AmrThicknessErrorGroupThresholdEnum,
	AmrThicknessErrorMaximumEnum,
	AmrThicknessErrorResolutionEnum,
	AmrThicknessErrorThresholdEnum,
	AmrTypeEnum,
	AnalysisCounterEnum,
	AnalysisTypeEnum,
	AugmentedLagrangianREnum,
	AugmentedLagrangianRholambdaEnum,
	AugmentedLagrangianRhopEnum,
	AugmentedLagrangianRlambdaEnum,
	AugmentedLagrangianThetaEnum,
	AutodiffCbufsizeEnum,
	AutodiffDependentObjectsEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffGcTriggerMaxSizeEnum,
	AutodiffGcTriggerRatioEnum,
	AutodiffIsautodiffEnum,
	AutodiffLbufsizeEnum,
	AutodiffNumDependentsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffObufsizeEnum,
	AutodiffTapeAllocEnum,
	AutodiffTbufsizeEnum,
	AutodiffXpEnum,
	BalancethicknessStabilizationEnum,
	BarystaticContributionsEnum,
	BasalforcingsBottomplumedepthEnum,
	BasalforcingsCrustthicknessEnum,
	BasalforcingsDeepwaterElevationEnum,
	BasalforcingsDeepwaterMeltingRateEnum,
	BasalforcingsDtbgEnum,
	BasalforcingsEnum,
	BasalforcingsIsmip6AverageTfEnum,
	BasalforcingsIsmip6BasinAreaEnum,
	BasalforcingsIsmip6DeltaTEnum,
	BasalforcingsIsmip6Gamma0Enum,
	BasalforcingsIsmip6IsLocalEnum,
	BasalforcingsIsmip6NumBasinsEnum,
	BasalforcingsIsmip6TfDepthsEnum,
	BasalforcingsLowercrustheatEnum,
	BasalforcingsMantleconductivityEnum,
	BasalforcingsNusseltEnum,
	BasalforcingsPicoAverageOverturningEnum,
	BasalforcingsPicoAverageSalinityEnum,
	BasalforcingsPicoAverageTemperatureEnum,
	BasalforcingsPicoBoxAreaEnum,
	BasalforcingsPicoFarOceansalinityEnum,
	BasalforcingsPicoFarOceantemperatureEnum,
	BasalforcingsPicoGammaTEnum,
	BasalforcingsPicoIsplumeEnum,
	BasalforcingsPicoMaxboxcountEnum,
	BasalforcingsPicoNumBasinsEnum,
	BasalforcingsPlumeradiusEnum,
	BasalforcingsPlumexEnum,
	BasalforcingsPlumeyEnum,
	BasalforcingsThresholdThicknessEnum,
	BasalforcingsTopplumedepthEnum,
	BasalforcingsUppercrustheatEnum,
	BasalforcingsUppercrustthicknessEnum,
	BasalforcingsUpperdepthMeltEnum,
	BasalforcingsUpperwaterElevationEnum,
	BasalforcingsUpperwaterMeltingRateEnum,
	CalvingCrevasseDepthEnum,
	CalvingHeightAboveFloatationEnum,
	CalvingLawEnum,
	CalvingMinthicknessEnum,
	ConfigurationTypeEnum,
	ConstantsGEnum,
	ConstantsNewtonGravityEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	ControlInputSizeMEnum,
	ControlInputSizeNEnum,
	ControlInputInterpolationEnum,
	CumBslcEnum,
	CumBslcIceEnum,
	CumBslcHydroEnum,
	CumBslcOceanEnum,
	CumBslcIcePartitionEnum,
	CumBslcHydroPartitionEnum,
	CumBslcOceanPartitionEnum,
	CumGmtslcEnum,
	CumGmslcEnum,
	DamageC1Enum,
	DamageC2Enum,
	DamageC3Enum,
	DamageC4Enum,
	DamageEnum,
	DamageEquivStressEnum,
	DamageEvolutionNumRequestedOutputsEnum,
	DamageEvolutionRequestedOutputsEnum,
	DamageHealingEnum,
	DamageKappaEnum,
	DamageLawEnum,
	DamageMaxDamageEnum,
	DamageStabilizationEnum,
	DamageStressThresholdEnum,
	DamageStressUBoundEnum,
	DebugProfilingEnum,
	DomainDimensionEnum,
	DomainTypeEnum,
	DslModelEnum,
	DslModelidEnum,
	DslNummodelsEnum,
	SolidearthIsExternalEnum,
	SolidearthExternalNatureEnum,
	SolidearthExternalModelidEnum,
	SolidearthExternalNummodelsEnum,
	SolidearthSettingsComputeBpGrdEnum,
	EarthIdEnum,
	ElasticEnum,
	EplZigZagCounterEnum,
	EsaHElasticEnum,
	EsaHemisphereEnum,
	EsaRequestedOutputsEnum,
	EsaUElasticEnum,
	ExtrapolationVariableEnum,
	FemModelCommEnum,
	FieldsEnum,
	FlowequationFeFSEnum,
	FlowequationIsFSEnum,
	FlowequationIsHOEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsMLHOEnum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FlowequationIsNitscheEnum,
	FeFSNitscheGammaEnum,
	FrictionCouplingEnum,
	FrictionDeltaEnum,
	FrictionEffectivePressureLimitEnum,
	FrictionFEnum,
	FrictionGammaEnum,
	FrictionLawEnum,
	FrictionPseudoplasticityExponentEnum,
	FrictionThresholdSpeedEnum,
	FrictionVoidRatioEnum,
	FrontalForcingsBasinIcefrontAreaEnum,
	FrontalForcingsNumberofBasinsEnum,
	FrontalForcingsParamEnum,
	GrdModelEnum,
	GroundinglineFrictionInterpolationEnum,
	GroundinglineMeltInterpolationEnum,
	GroundinglineMigrationEnum,
	HydrologyAveragingEnum,
	HydrologyCavitySpacingEnum,
	HydrologyChannelConductivityEnum,
	HydrologyChannelSheetWidthEnum,
	HydrologyEnglacialVoidRatioEnum,
	HydrologyIschannelsEnum,
	HydrologyMeltFlagEnum,
	HydrologyModelEnum,
	HydrologyNumRequestedOutputsEnum,
	HydrologyPressureMeltCoefficientEnum,
	HydrologyRelaxationEnum,
	HydrologyRequestedOutputsEnum,
	HydrologySedimentKmaxEnum,
	HydrologyStepsPerStepEnum,
	HydrologyStorageEnum,
	HydrologydcEplColapseThicknessEnum,
	HydrologydcEplConductivityEnum,
	HydrologydcEplInitialThicknessEnum,
	HydrologydcEplLayerCompressibilityEnum,
	HydrologydcEplMaxThicknessEnum,
	HydrologydcEplPoreWaterMassEnum,
	HydrologydcEplThickCompEnum,
	HydrologydcEplflipLockEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcMaxIterEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologydcPenaltyLockEnum,
	HydrologydcRelTolEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentLayerCompressibilityEnum,
	HydrologydcSedimentPoreWaterMassEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcUnconfinedFlagEnum,
	HydrologyshreveStabilizationEnum,
	IcecapToEarthCommEnum,
	IndexEnum,
	InputFileNameEnum,
	DirectoryNameEnum,
	IndicesEnum,
	InputToDepthaverageInEnum,
	InputToDepthaverageOutEnum,
	InputToExtrudeEnum,
	InputToL2ProjectEnum,
	InputToSmoothEnum,
	InversionAlgorithmEnum,
	InversionControlParametersEnum,
	InversionControlScalingFactorsEnum,
	InversionCostFunctionsEnum,
	InversionDxminEnum,
	InversionGatolEnum,
	InversionGradientScalingEnum,
	InversionGrtolEnum,
	InversionGttolEnum,
	InversionIncompleteAdjointEnum,
	InversionIscontrolEnum,
	InversionMaxiterEnum,
	InversionMaxiterPerStepEnum,
	InversionMaxstepsEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionTypeEnum,
	IvinsEnum,
	IsSlcCouplingEnum,
	LevelsetKillIcebergsEnum,
	LevelsetReinitFrequencyEnum,
	LevelsetStabilizationEnum,
	LockFileNameEnum,
	LoveAllowLayerDeletionEnum,
	LoveCoreMantleBoundaryEnum,
	LoveEarthMassEnum,
	LoveForcingTypeEnum,
	LoveFrequenciesEnum,
	LoveIsTemporalEnum,
	LoveG0Enum,
	LoveGravitationalConstantEnum,
	LoveInnerCoreBoundaryEnum,
	LoveComplexComputationEnum,
	LoveIntStepsPerLayerEnum,
	LoveKernelsEnum,
	LoveMu0Enum,
	LoveNfreqEnum,
	LoveNTemporalIterationsEnum,
	LoveNYiEquationsEnum,
	LoveR0Enum,
	LoveShNmaxEnum,
	LoveShNminEnum,
	LoveStartingLayerEnum,
	LoveUnderflowTolEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportRequestedOutputsEnum,
	MasstransportStabilizationEnum,
	MaterialsBetaEnum,
	MaterialsEarthDensityEnum,
	MaterialsEffectiveconductivityAveragingEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsMuWaterEnum,
	MaterialsRheologyLawEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoSeawaterEnum,
	MaterialsTemperateiceconductivityEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MeltingOffsetEnum,
	MeshAverageVertexConnectivityEnum,
	MeshElementtypeEnum,
	MeshNumberoflayersEnum,
	MeshNumberofverticesEnum,
	MeshNumberofelementsEnum,
	MigrationMaxEnum,
	ModelIdEnum,
	NbinsEnum,
	NodesEnum,
	NumModelsEnum,
	OceanGridNxEnum,
	OceanGridNyEnum,
	OceanGridXEnum,
	OceanGridYEnum,
	OutputBufferPointerEnum,
	OutputBufferSizePointerEnum,
	OutputFileNameEnum,
	OutputFilePointerEnum,
	OutputdefinitionEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuIsdakotaEnum,
	QmuOutNameEnum,
	QmuOutputEnum,
	QmuCurrEvalIdEnum,
	QmuNsampleEnum,
	QmuResponsedescriptorsEnum,
	QmuVariableDescriptorsEnum,
	QmuVariablePartitionsEnum,
	QmuVariablePartitionsNpartEnum,
	QmuVariablePartitionsNtEnum,
	QmuResponsePartitionsEnum,
	QmuResponsePartitionsNpartEnum,
	QmuStatisticsEnum,
	QmuNumstatisticsEnum,
	QmuNdirectoriesEnum,
	QmuNfilesPerDirectoryEnum,
	QmuStatisticsMethodEnum,
	QmuMethodsEnum,
	RestartFileNameEnum,
	ResultsEnum,
	RootPathEnum,
	ModelnameEnum,
	SamplingAlphaEnum,
	SamplingPhiEnum,
	SamplingNumRequestedOutputsEnum,
	SamplingRequestedOutputsEnum,
	SamplingRobinEnum,
	SamplingSeedEnum,
	SamplingTauEnum,
	SaveResultsEnum,
	SolidearthPartitionIceEnum,
	SolidearthPartitionHydroEnum,
	SolidearthPartitionOceanEnum,
	SolidearthNpartIceEnum,
	SolidearthNpartOceanEnum,
	SolidearthNpartHydroEnum,
	SolidearthPlanetRadiusEnum,
	SolidearthPlanetAreaEnum,
	SolidearthSettingsAbstolEnum,
	SolidearthSettingsCrossSectionShapeEnum,
	RotationalAngularVelocityEnum,
	SolidearthSettingsElasticEnum,
	SolidearthSettingsViscousEnum,
	SealevelchangeGeometryDoneEnum,
	SealevelchangeViscousNumStepsEnum,
	SealevelchangeViscousTimesEnum,
	SealevelchangeViscousIndexEnum,
	RotationalEquatorialMoiEnum,
	TidalLoveHEnum,
	TidalLoveKEnum,
	TidalLoveLEnum,
	TidalLoveK2SecularEnum,
	LoadLoveHEnum,
	LoadLoveKEnum,
	LoadLoveLEnum,
	LoveTimeFreqEnum,
	LoveIsTimeEnum,
	SealevelchangeGSelfAttractionEnum,
	SealevelchangeGViscoElasticEnum,
	SolidearthSettingsSealevelLoadingEnum,
	SolidearthSettingsGRDEnum,
	SolidearthSettingsRunFrequencyEnum,
	SolidearthSettingsTimeAccEnum,
	SealevelchangeHViscoElasticEnum,
	SolidearthSettingsHorizEnum,
	SolidearthSettingsMaxiterEnum,
	SolidearthSettingsGrdOceanEnum,
	SolidearthSettingsOceanAreaScalingEnum,
	RotationalPolarMoiEnum,
	SolidearthSettingsReltolEnum,
	SealevelchangeRequestedOutputsEnum,
	SolidearthSettingsSelfAttractionEnum,
	SolidearthSettingsRotationEnum,
	SolidearthSettingsMaxSHCoeffEnum,
	SealevelchangeRunCountEnum,
	SealevelchangeTransitionsEnum,
	SealevelchangeUViscoElasticEnum,
	SettingsIoGatherEnum,
	SettingsNumResultsOnNodesEnum,
	SettingsOutputFrequencyEnum,
	SettingsCheckpointFrequencyEnum,
	SettingsResultsOnNodesEnum,
	SettingsSbCouplingFrequencyEnum,
	SettingsSolverResidueThresholdEnum,
	SettingsWaitonlockEnum,
	SmbAIceEnum,
	SmbAIdxEnum,
	SmbASnowEnum,
	SmbAccualtiEnum,
	SmbAccugradEnum,
	SmbAccurefEnum,
	SmbAdThreshEnum,
	SmbAveragingEnum,
	SmbDesfacEnum,
	SmbDpermilEnum,
	SmbDsnowIdxEnum,
	SmbCldFracEnum,
	SmbDelta18oEnum,
	SmbDelta18oSurfaceEnum,
	SmbDenIdxEnum,
	SmbDtEnum,
	SmbEnum,
	SmbFEnum,
	SmbInitDensityScalingEnum,
	SmbIsaccumulationEnum,
	SmbIsalbedoEnum,
	SmbIsconstrainsurfaceTEnum,
	SmbIsd18opdEnum,
	SmbIsdelta18oEnum,
	SmbIsdensificationEnum,
	SmbIsfirnwarmingEnum,
	SmbIsgraingrowthEnum,
	SmbIsmeltEnum,
	SmbIsmungsmEnum,
	SmbIsprecipscaledEnum,
	SmbIssetpddfacEnum,
	SmbIsshortwaveEnum,
	SmbIstemperaturescaledEnum,
	SmbIsthermalEnum,
	SmbIsturbulentfluxEnum,
	SmbKEnum,
	SmbNumRequestedOutputsEnum,
	SmbPfacEnum,
	SmbRdlEnum,
	SmbRequestedOutputsEnum,
	SmbRlapsEnum,
	SmbRlapslgmEnum,
	SmbRunoffaltiEnum,
	SmbRunoffgradEnum,
	SmbRunoffrefEnum,
	SmbSealevEnum,
	SmbStepsPerStepEnum,
	SmbSwIdxEnum,
	SmbT0dryEnum,
	SmbT0wetEnum,
	SmbTdiffEnum,
	SmbThermoDeltaTScalingEnum,
	SmbTemperaturesReconstructedYearsEnum,
	SmbPrecipitationsReconstructedYearsEnum,
	SmoothThicknessMultiplierEnum,
	SolutionTypeEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	StepEnum,
	StepsEnum,
	StressbalanceAbstolEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReltolEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
	ThermalIsdrainicecolumnEnum,
	ThermalIsdynamicbasalspcEnum,
	ThermalIsenthalpyEnum,
	ThermalMaxiterEnum,
	ThermalNumRequestedOutputsEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalReltolEnum,
	ThermalRequestedOutputsEnum,
	ThermalStabilizationEnum,
	ThermalWatercolumnUpperlimitEnum,
	TimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingCouplingTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingInterpForcingEnum,
	TimesteppingCycleForcingEnum,
	TimesteppingStartTimeEnum,
	TimesteppingTimeStepEnum,
	TimesteppingTimeStepMaxEnum,
	TimesteppingTimeStepMinEnum,
	TimesteppingTypeEnum,
	ToMITgcmCommEnum,
	ToolkitsFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	ToolkitsTypesEnum,
	TransientAmrFrequencyEnum,
	TransientIsdamageevolutionEnum,
	TransientIsesaEnum,
	TransientIsgiaEnum,
	TransientIsgroundinglineEnum,
	TransientIshydrologyEnum,
	TransientIsmasstransportEnum, 
	TransientIsoceantransportEnum,
	TransientIsmovingfrontEnum,
	TransientIsoceancouplingEnum,
	TransientIssamplingEnum,
	TransientIsslcEnum,
	TransientIssmbEnum,
	TransientIsstressbalanceEnum,
	TransientIsthermalEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	VelocityEnum,
	XxeEnum,
	YyeEnum,
	ZzeEnum,
	AreaeEnum,
	WorldCommEnum,
	/*}}}*/
	ParametersENDEnum,
	InputsSTARTEnum,
	/*Inputs{{{*/
	AccumulatedDeltaBottomPressureEnum,
	AccumulatedDeltaIceThicknessEnum,
	AccumulatedDeltaTwsEnum,
	AdjointEnum,
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AirEnum,
	ApproximationEnum,
	BalancethicknessMisfitEnum,
	BalancethicknessOmega0Enum,
	BalancethicknessOmegaEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessThickeningRateEnum,
	BasalCrevasseEnum,
	BasalforcingsFloatingiceMeltingRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsGroundediceMeltingRateEnum,
	BasalforcingsPerturbationMeltingRateEnum,
	BasalforcingsIsmip6BasinIdEnum,
	BasalforcingsIsmip6TfEnum,
	BasalforcingsIsmip6TfShelfEnum,
	BasalforcingsIsmip6MeltAnomalyEnum,
	BasalforcingsMeltrateFactorEnum,
	BasalforcingsOceanSalinityEnum,
	BasalforcingsOceanTempEnum,
	BasalforcingsPicoBasinIdEnum,
	BasalforcingsPicoBoxIdEnum,
	BasalforcingsPicoOverturningCoeffEnum,
	BasalforcingsPicoSubShelfOceanOverturningEnum,
	BasalforcingsPicoSubShelfOceanSalinityEnum,
	BasalforcingsPicoSubShelfOceanTempEnum,
	BasalStressxEnum,
	BasalStressyEnum,
	BasalStressEnum,
	BaseEnum,
	BaseOldEnum,
	BaseSlopeXEnum,
	BaseSlopeYEnum,
	BedEnum,
	BedGRDEnum,
	BedEastEnum,
	BedEastGRDEnum,
	BedNorthEnum,
	BedNorthGRDEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BottomPressureEnum,
	BottomPressureOldEnum,
	CalvingCalvingrateEnum,
	CalvingHabFractionEnum,
	CalvingMeltingrateEnum,
	CalvingStressThresholdFloatingiceEnum,
	CalvingStressThresholdGroundediceEnum,
	CalvinglevermannCoeffEnum,
	CalvingratexAverageEnum,
	CalvingratexEnum,
	CalvingrateyAverageEnum,
	CalvingrateyEnum,
	CalvingFluxLevelsetEnum,
	CalvingMeltingFluxLevelsetEnum,
	ConvergedEnum,
	CrevasseDepthEnum,
	DamageDEnum,
	DamageDOldEnum,
	DamageDbarEnum,
	DamageDbarOldEnum,
	DamageFEnum,
	DegreeOfChannelizationEnum,
	DepthBelowSurfaceEnum,
	DeltaIceThicknessEnum,
	DeltaTwsEnum,
	DeltaBottomPressureEnum,
	DeltaDslEnum,
	DslOldEnum,
	DslEnum,
	DeltaStrEnum,
	StrOldEnum,
	StrEnum,
	DeviatoricStresseffectiveEnum,
	DeviatoricStressxxEnum,
	DeviatoricStressxyEnum,
	DeviatoricStressxzEnum,
	DeviatoricStressyyEnum,
	DeviatoricStressyzEnum,
	DeviatoricStresszzEnum,
	DeviatoricStress1Enum,
	DeviatoricStress2Enum,
	DistanceToCalvingfrontEnum,
	DistanceToGroundinglineEnum,
	Domain2DhorizontalEnum,
	Domain2DverticalEnum,
	Domain3DEnum,
	DragCoefficientAbsGradientEnum,
	DrivingStressXEnum,
	DrivingStressYEnum,
	DummyEnum,
   EffectivePressureEnum,
	EffectivePressureSubstepEnum,
	EffectivePressureTransientEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	EplHeadEnum,
   EplHeadOldEnum,
	EplHeadSlopeXEnum,
	EplHeadSlopeYEnum,
	EplHeadSubstepEnum,
   EplHeadTransientEnum,
	EsaEmotionEnum,
	EsaNmotionEnum,
	EsaRotationrateEnum,
	EsaStrainratexxEnum,
	EsaStrainratexyEnum,
	EsaStrainrateyyEnum,
	EsaUmotionEnum,
	EsaXmotionEnum,
	EsaYmotionEnum,
	EtaDiffEnum,
	FlowequationBorderFSEnum,
	FrictionAsEnum,
	FrictionCEnum,
	FrictionCmaxEnum,
	FrictionCoefficientEnum,
	FrictionCoefficientcoulombEnum,
	FrictionEffectivePressureEnum,
	FrictionMEnum,
	FrictionPEnum,
	FrictionPressureAdjustedTemperatureEnum,
	FrictionQEnum,
	FrictionSedimentCompressibilityCoefficientEnum,
	FrictionTillFrictionAngleEnum,
	FrictionWaterLayerEnum,
	FrictionfEnum,
	FrontalForcingsBasinIdEnum,
	FrontalForcingsSubglacialDischargeEnum,
	FrontalForcingsThermalForcingEnum,
	GeometryHydrostaticRatioEnum,
	NGiaEnum,
	NGiaRateEnum,
	UGiaEnum,
	UGiaRateEnum,
	GradientEnum,
	GroundinglineHeightEnum,
	HydraulicPotentialEnum,
	HydraulicPotentialOldEnum,
	HydrologyBasalFluxEnum,
	HydrologyBumpHeightEnum,
	HydrologyBumpSpacingEnum,
	HydrologydcBasalMoulinInputEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplThicknessOldEnum,
	HydrologydcEplThicknessSubstepEnum,
	HydrologydcEplThicknessTransientEnum,
	HydrologydcMaskEplactiveEltEnum,
	HydrologydcMaskEplactiveNodeEnum,
	HydrologydcMaskThawedEltEnum,
	HydrologydcMaskThawedNodeEnum,
	HydrologydcSedimentTransmitivityEnum,
   HydrologyDrainageRateEnum,
   HydrologyEnglacialInputEnum,
	HydrologyGapHeightEnum,
	HydrologyHeadEnum,
	HydrologyHeadOldEnum,
	HydrologyMoulinInputEnum,
	HydrologyNeumannfluxEnum,
	HydrologyReynoldsEnum,
	HydrologySheetConductivityEnum,
	HydrologySheetThicknessEnum,
	HydrologySheetThicknessOldEnum,
	HydrologyTwsEnum,
	HydrologyTwsSpcEnum,
	HydrologyTwsAnalysisEnum,
	HydrologyWatercolumnMaxEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	IceEnum,
	IceMaskNodeActivationEnum,
	InputEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionSurfaceObsEnum,
	InversionThicknessObsEnum,
	InversionVelObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	LevelsetfunctionSlopeXEnum,
	LevelsetfunctionSlopeYEnum,
	LevelsetObservationEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	MaskOceanLevelsetEnum,
	MaskIceLevelsetEnum,
	MaskIceRefLevelsetEnum,
	MasstransportSpcthicknessEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyEEnum,
	MaterialsRheologyEbarEnum,
	MaterialsRheologyEcEnum,
	MaterialsRheologyEcbarEnum,
	MaterialsRheologyEsEnum,
	MaterialsRheologyEsbarEnum,
	MaterialsRheologyNEnum,
	MeshScaleFactorEnum,
	MeshVertexonbaseEnum,
	MeshVertexonboundaryEnum,
	MeshVertexonsurfaceEnum,
	MisfitEnum,
	MovingFrontalVxEnum,
	MovingFrontalVyEnum,
	NeumannfluxEnum,
	NewDamageEnum,
	NodeEnum,
	OmegaAbsGradientEnum,
	OceantransportSpcbottompressureEnum,
	OceantransportSpcstrEnum,
	OceantransportSpcdslEnum,
	P0Enum,
	P1Enum,
	PartitioningEnum,
	PressureEnum,
	RadarEnum,
	RadarAttenuationMacGregorEnum,
	RadarAttenuationWolffEnum,
	RadarIcePeriodEnum,
	RadarPowerMacGregorEnum,
	RadarPowerWolffEnum,
	RheologyBAbsGradientEnum,
	RheologyBInitialguessEnum,
	RheologyBInitialguessMisfitEnum,
	RheologyBbarAbsGradientEnum,
	SampleEnum,
	SamplingBetaEnum,
	SamplingKappaEnum,
	SealevelEnum,
	SealevelGRDEnum,
	SealevelBarystaticMaskEnum,
	SealevelBarystaticIceMaskEnum,
	SealevelBarystaticIceWeightsEnum,
	SealevelBarystaticIceAreaEnum,
	SealevelBarystaticIceLatbarEnum,
	SealevelBarystaticIceLongbarEnum,
	SealevelBarystaticIceLoadEnum,
	SealevelBarystaticHydroMaskEnum,
	SealevelBarystaticHydroWeightsEnum,
	SealevelBarystaticHydroAreaEnum,
	SealevelBarystaticHydroLatbarEnum,
	SealevelBarystaticHydroLongbarEnum,
	SealevelBarystaticHydroLoadEnum,
	SealevelBarystaticBpMaskEnum,
	SealevelBarystaticBpWeightsEnum,
	SealevelBarystaticBpAreaEnum,
	SealevelBarystaticBpLoadEnum,
	SealevelBarystaticOceanMaskEnum,
	SealevelBarystaticOceanWeightsEnum,
	SealevelBarystaticOceanAreaEnum,
	SealevelBarystaticOceanLatbarEnum,
	SealevelBarystaticOceanLongbarEnum,
	SealevelBarystaticOceanLoadEnum,
	SealevelNEsaEnum,
	SealevelNEsaRateEnum,
	SealevelRSLEnum,
	BslcEnum,
	BslcIceEnum,
	BslcHydroEnum,
	BslcOceanEnum,
	BslcRateEnum,
	GmtslcEnum,
	SealevelGrotm1Enum,
	SealevelGrotm2Enum,
	SealevelGrotm3Enum,
	SealevelGUrotm1Enum,
	SealevelGUrotm2Enum,
	SealevelGUrotm3Enum,
	SealevelGNrotm1Enum,
	SealevelGNrotm2Enum,
	SealevelGNrotm3Enum,
	SealevelGErotm1Enum,
	SealevelGErotm2Enum,
	SealevelGErotm3Enum,
	SealevelRSLBarystaticEnum,
	SealevelRSLRateEnum,
	SealevelUGrdEnum,
	SealevelNGrdEnum,
	SealevelUEastEsaEnum,
	SealevelUNorthEsaEnum,
	SealevelchangeIndicesEnum,
	SealevelchangeGEnum,
	SealevelchangeGUEnum,
	SealevelchangeGEEnum,
	SealevelchangeGNEnum,
	SealevelchangeGsubelOceanEnum,
	SealevelchangeGUsubelOceanEnum,
	SealevelchangeGEsubelOceanEnum,
	SealevelchangeGNsubelOceanEnum,
	SealevelchangeGsubelIceEnum,
	SealevelchangeGUsubelIceEnum,
	SealevelchangeGEsubelIceEnum,
	SealevelchangeGNsubelIceEnum,
	SealevelchangeGsubelHydroEnum,
	SealevelchangeGUsubelHydroEnum,
	SealevelchangeGEsubelHydroEnum,
	SealevelchangeGNsubelHydroEnum,
	SealevelchangeViscousRSLEnum,
	SealevelchangeViscousUEnum,
	SealevelchangeViscousNEnum,
	SealevelchangeViscousEEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadSubstepEnum,
	SedimentHeadTransientEnum,
	SedimentHeadResidualEnum,
	SedimentHeadStackedEnum,
	SigmaNNEnum,
	SigmaVMEnum,
	SmbAccumulatedECEnum,
	SmbAccumulatedMassBalanceEnum,
	SmbAccumulatedMeltEnum,
	SmbAccumulatedPrecipitationEnum,
	SmbAccumulatedRainEnum,
	SmbAccumulatedRefreezeEnum,
	SmbAccumulatedRunoffEnum,
	SmbAEnum,
	SmbAdiffEnum,
	SmbAValueEnum,
	SmbAccumulationEnum,
	SmbAdiffiniEnum,
	SmbAiniEnum,
	SmbBMaxEnum,
	SmbBMinEnum,
	SmbBNegEnum,
	SmbBPosEnum,
	SmbCEnum,
	SmbCcsnowValueEnum,
	SmbCciceValueEnum,
	SmbCotValueEnum,
	SmbDEnum,
	SmbDailyairdensityEnum,
	SmbDailyairhumidityEnum,
	SmbDailydlradiationEnum,
	SmbDailydsradiationEnum,
	SmbDailypressureEnum,
	SmbDailyrainfallEnum,
	SmbDailysnowfallEnum,
	SmbDailytemperatureEnum,
	SmbDailywindspeedEnum,
	SmbDiniEnum,
	SmbDlwrfEnum,
	SmbDswrfEnum,
	SmbDswdiffrfEnum,
	SmbDzAddEnum,
	SmbDzEnum,
	SmbDzMinEnum,
	SmbDzTopEnum,
	SmbDziniEnum,
	SmbEAirEnum,
	SmbECEnum,
	SmbECDtEnum,
	SmbECiniEnum,
	SmbElaEnum,
	SmbEvaporationEnum,
	SmbFACEnum,
	SmbGdnEnum,
	SmbGdniniEnum,
	SmbGspEnum,
	SmbGspiniEnum,
	SmbHrefEnum,
	SmbIsInitializedEnum,
	SmbMAddEnum,
	SmbMassBalanceEnum,
   SmbMassBalanceSubstepEnum,
   SmbMassBalanceTransientEnum,
	SmbMeanLHFEnum,
	SmbMeanSHFEnum,
	SmbMeanULWEnum,
	SmbMeltEnum,
	SmbMInitnum,
	SmbMonthlytemperaturesEnum,
	SmbMSurfEnum,
	SmbNetLWEnum,
	SmbNetSWEnum,
	SmbPAirEnum,
	SmbPEnum,
	SmbPddfacIceEnum,
	SmbPddfacSnowEnum,
	SmbPrecipitationEnum,
	SmbPrecipitationsAnomalyEnum,
	SmbPrecipitationsLgmEnum,
	SmbPrecipitationsPresentdayEnum,
	SmbPrecipitationsReconstructedEnum,
	SmbRainEnum,
	SmbReEnum,
	SmbRefreezeEnum,
	SmbReiniEnum,
	SmbRunoffEnum,
   SmbRunoffSubstepEnum,
   SmbRunoffTransientEnum,
	SmbS0gcmEnum,
	SmbS0pEnum,
	SmbS0tEnum,
	SmbSizeiniEnum,
	SmbSmbCorrEnum,
	SmbSmbrefEnum,
	SmbSzaValueEnum,
	SmbTEnum,
	SmbTaEnum,
	SmbTeValueEnum,
	SmbTemperaturesAnomalyEnum,
	SmbTemperaturesLgmEnum,
	SmbTemperaturesPresentdayEnum,
	SmbTemperaturesReconstructedEnum,
	SmbTiniEnum,
	SmbTmeanEnum,
	SmbTzEnum,
	SmbVEnum,
	SmbVmeanEnum,
	SmbVzEnum,
	SmbWEnum,
	SmbWAddEnum,
	SmbWiniEnum,
	SmbZMaxEnum,
	SmbZMinEnum,
	SmbZTopEnum,
	SmbZYEnum,
	SolidearthExternalDisplacementEastRateEnum,
	SolidearthExternalDisplacementNorthRateEnum,
	SolidearthExternalDisplacementUpRateEnum,
	SolidearthExternalGeoidRateEnum,
	StrainRateeffectiveEnum,
	StrainRateparallelEnum,
	StrainRateperpendicularEnum,
	StrainRatexxEnum,
	StrainRatexyEnum,
	StrainRatexzEnum,
	StrainRateyyEnum,
	StrainRateyzEnum,
	StrainRatezzEnum,
	StressMaxPrincipalEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	SurfaceAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	AreaEnum,
	SealevelAreaEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceCrevasseEnum,
	SurfaceEnum,
	SurfaceOldEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceObservationEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePDDEnum,
	TemperaturePicardEnum,
	TemperatureSEMICEnum,
	ThermalSpctemperatureEnum,
	ThicknessAbsGradientEnum,
	ThicknessAbsMisfitEnum,
	ThicknessAcrossGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessEnum,
	ThicknessOldEnum,
	ThicknessPositiveEnum,
	ThicknessResidualEnum,
	TransientAccumulatedDeltaIceThicknessEnum,
	VelEnum,
	VxAverageEnum,
	VxBaseEnum,
	VxEnum,
	VxMeshEnum,
	VxObsEnum,
	VxShearEnum,
	VxSurfaceEnum,
	VyAverageEnum,
	VyBaseEnum,
	VyEnum,
	VyMeshEnum,
	VyObsEnum,
	VyShearEnum,
	VySurfaceEnum,
	VzEnum,
	VzFSEnum,
	VzHOEnum,
	VzMeshEnum,
	VzSSAEnum,
	WaterColumnOldEnum,
	WatercolumnEnum,
	WaterfractionDrainageEnum,
	WaterfractionDrainageIntegratedEnum,
	WaterfractionEnum,
	WaterheightEnum,
	WeightsLevelsetObservationEnum,
	WeightsSurfaceObservationEnum,
	OldAccumulatedDeltaBottomPressureEnum,
	OldAccumulatedDeltaIceThicknessEnum,
	OldAccumulatedDeltaTwsEnum,
	Outputdefinition1Enum,
	Outputdefinition10Enum,
	Outputdefinition11Enum,
	Outputdefinition12Enum,
	Outputdefinition13Enum,
	Outputdefinition14Enum,
	Outputdefinition15Enum,
	Outputdefinition16Enum,
	Outputdefinition17Enum,
	Outputdefinition18Enum,
	Outputdefinition19Enum,
	Outputdefinition20Enum,
	Outputdefinition21Enum,
	Outputdefinition22Enum,
	Outputdefinition23Enum,
	Outputdefinition24Enum,
	Outputdefinition25Enum,
	Outputdefinition26Enum,
	Outputdefinition27Enum,
	Outputdefinition28Enum,
	Outputdefinition29Enum,
	Outputdefinition2Enum,
	Outputdefinition30Enum,
	Outputdefinition31Enum,
	Outputdefinition32Enum,
	Outputdefinition33Enum,
	Outputdefinition34Enum,
	Outputdefinition35Enum,
	Outputdefinition36Enum,
	Outputdefinition37Enum,
	Outputdefinition38Enum,
	Outputdefinition39Enum,
	Outputdefinition3Enum,
	Outputdefinition40Enum,
	Outputdefinition41Enum,
	Outputdefinition42Enum,
	Outputdefinition43Enum,
	Outputdefinition44Enum,
	Outputdefinition45Enum,
	Outputdefinition46Enum,
	Outputdefinition47Enum,
	Outputdefinition48Enum,
	Outputdefinition49Enum,
	Outputdefinition4Enum,
	Outputdefinition50Enum,
	Outputdefinition51Enum,
	Outputdefinition52Enum,
	Outputdefinition53Enum,
	Outputdefinition54Enum,
	Outputdefinition55Enum,
	Outputdefinition56Enum,
	Outputdefinition57Enum,
	Outputdefinition58Enum,
	Outputdefinition59Enum,
	Outputdefinition5Enum,
	Outputdefinition60Enum,
	Outputdefinition61Enum,
	Outputdefinition62Enum,
	Outputdefinition63Enum,
	Outputdefinition64Enum,
	Outputdefinition65Enum,
	Outputdefinition66Enum,
	Outputdefinition67Enum,
	Outputdefinition68Enum,
	Outputdefinition69Enum,
	Outputdefinition6Enum,
	Outputdefinition70Enum,
	Outputdefinition71Enum,
	Outputdefinition72Enum,
	Outputdefinition73Enum,
	Outputdefinition74Enum,
	Outputdefinition75Enum,
	Outputdefinition76Enum,
	Outputdefinition77Enum,
	Outputdefinition78Enum,
	Outputdefinition79Enum,
	Outputdefinition7Enum,
	Outputdefinition80Enum,
	Outputdefinition81Enum,
	Outputdefinition82Enum,
	Outputdefinition83Enum,
	Outputdefinition84Enum,
	Outputdefinition85Enum,
	Outputdefinition86Enum,
	Outputdefinition87Enum,
	Outputdefinition88Enum,
	Outputdefinition89Enum,
	Outputdefinition8Enum,
	Outputdefinition90Enum,
	Outputdefinition91Enum,
	Outputdefinition92Enum,
	Outputdefinition93Enum,
	Outputdefinition94Enum,
	Outputdefinition95Enum,
	Outputdefinition96Enum,
	Outputdefinition97Enum,
	Outputdefinition98Enum,
	Outputdefinition99Enum,
	Outputdefinition9Enum,
	Outputdefinition100Enum,
	/*}}}*/
	InputsENDEnum,
	/*Other{{{*/
	AbsoluteEnum,
	AdaptiveTimesteppingEnum,
	AdjointBalancethickness2AnalysisEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AggressiveMigrationEnum,
	AmrBamgEnum,
	AmrNeopzEnum,
	AndroidFrictionCoefficientEnum,
	ArrheniusEnum,
	AutodiffJacobianEnum,
	Balancethickness2AnalysisEnum,
	Balancethickness2SolutionEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessApparentMassbalanceEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancethicknessSolutionEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	BasalforcingsIsmip6Enum,
	BasalforcingsPicoEnum,
	BeckmannGoosseFloatingMeltRateEnum,
	BedSlopeSolutionEnum,
	BoolExternalResultEnum,
	BoolInputEnum,
	IntInputEnum,
	DoubleInputEnum,
	BoolParamEnum,
	BoundaryEnum,
	BuddJackaEnum,
	CalvingDev2Enum,
	CalvingHabEnum,
	CalvingLevermannEnum,
	CalvingVonmisesEnum,
	CfdragcoeffabsgradEnum,
	CfsurfacelogvelEnum,
	CfsurfacesquareEnum,
	CflevelsetmisfitEnum,
	ChannelEnum,
	ChannelAreaEnum,
	ChannelAreaOldEnum,
	ChannelDischargeEnum,
	ClosedEnum,
	ColinearEnum,
	ConstraintsEnum,
	ContactEnum,
	ContourEnum,
	ContoursEnum,
	ControlInputEnum,
	ControlInputGradEnum,
	ControlInputMaxsEnum,
	ControlInputMinsEnum,
	ControlInputValuesEnum,
	CrouzeixRaviartEnum,
	CuffeyEnum,
	CuffeyTemperateEnum,
	DamageEvolutionAnalysisEnum,
	DamageEvolutionSolutionEnum,
	DataSetEnum,
	DataSetParamEnum,
	DatasetInputEnum,
	DefaultAnalysisEnum,
	DefaultCalvingEnum,
	DenseEnum,
	DependentObjectEnum,
	DepthAverageAnalysisEnum,
	DeviatoricStressErrorEstimatorEnum,
	DivergenceEnum,
	Domain3DsurfaceEnum,
	DoubleArrayInputEnum,
	ArrayInputEnum,
	DoubleExternalResultEnum,
	DoubleMatArrayParamEnum,
	DoubleMatExternalResultEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementHookEnum,
	ElementSIdEnum,
	EnthalpyAnalysisEnum,
	EsaAnalysisEnum,
	EsaSolutionEnum,
	EsaTransitionsEnum,
	ExternalResultEnum,
	ExtrapolationAnalysisEnum,
	ExtrudeFromBaseAnalysisEnum,
	ExtrudeFromTopAnalysisEnum,
	FSApproximationEnum,
	FSSolverEnum,
	FSpressureEnum,
	FSvelocityEnum,
	FemModelEnum,
	FileParamEnum,
	FixedTimesteppingEnum,
	FloatingAreaEnum,
	FloatingAreaScaledEnum,
	FloatingMeltRateEnum,
	FreeEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	FrontalForcingsDefaultEnum,
	FrontalForcingsRignotEnum,
	FsetEnum,
	FullMeltOnPartiallyFloatingEnum,
	GLheightadvectionAnalysisEnum,
	GaussPentaEnum,
	GaussSegEnum,
	GaussTetraEnum,
	GaussTriaEnum,
	GenericOptionEnum,
	GenericParamEnum,
	GenericExternalResultEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	Gradient4Enum,
	GroundedAreaEnum,
	GroundedAreaScaledEnum,
	GroundingOnlyEnum,
	GroundinglineMassFluxEnum,
	GsetEnum,
	GslEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	HookEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyGlaDSAnalysisEnum,
	HydrologyGlaDSEnum,
	HydrologyPismAnalysisEnum,
	HydrologyShaktiAnalysisEnum,
	HydrologyShreveAnalysisEnum,
	HydrologySolutionEnum,
	HydrologydcEnum,
	HydrologypismEnum,
	HydrologyshaktiEnum,
	HydrologyshreveEnum,
	IceMassEnum,
	IceMassScaledEnum,
	IceVolumeAboveFloatationEnum,
	IceVolumeAboveFloatationScaledEnum,
	IceVolumeEnum,
	IceVolumeScaledEnum,
	IcefrontMassFluxEnum,
	IcefrontMassFluxLevelsetEnum,
	IncrementalEnum,
	IndexedEnum,
	IntExternalResultEnum,
	ElementInputEnum,
	IntMatExternalResultEnum,
	IntMatParamEnum,
	IntParamEnum,
	IntVecParamEnum,
	InputsEnum,
	InternalEnum,
	IntersectEnum,
	InversionVzObsEnum,
	JEnum,
	L1L2ApproximationEnum,
	MLHOApproximationEnum,
	L2ProjectionBaseAnalysisEnum,
	L2ProjectionEPLAnalysisEnum,
	LACrouzeixRaviartEnum,
	LATaylorHoodEnum,
	LambdaSEnum,
	LevelsetAnalysisEnum,
	LevelsetfunctionPicardEnum,
	LinearFloatingMeltRateEnum,
	LliboutryDuvalEnum,
	LoadsEnum,
	LoveAnalysisEnum,
	LoveHiEnum,
	LoveHrEnum,
	LoveKernelsImagEnum,
	LoveKernelsRealEnum,
	LoveKiEnum,
	LoveKrEnum,
	LoveLiEnum,
	LoveLrEnum,
	LoveSolutionEnum,
	MINIEnum,
	MINIcondensedEnum,
	MantlePlumeGeothermalFluxEnum,
	MassFluxEnum,
	MassconEnum,
	MassconaxpbyEnum,
	MassfluxatgateEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	MatdamageiceEnum,
	MatenhancediceEnum,
	MaterialsEnum,
	MatestarEnum,
	MaticeEnum,
	MatlithoEnum,
	MathydroEnum,
	MatrixParamEnum,
	MaxAbsVxEnum,
	MaxAbsVyEnum,
	MaxAbsVzEnum,
	MaxDivergenceEnum,
	MaxVelEnum,
	MaxVxEnum,
	MaxVyEnum,
	MaxVzEnum,
	MelangeEnum,
	MeltingAnalysisEnum,
	MeshElementsEnum,
	MeshXEnum,
	MeshYEnum,
	MinVelEnum,
	MinVxEnum,
	MinVyEnum,
	MinVzEnum,
	MismipFloatingMeltRateEnum,
	MoulinEnum,
	MpiDenseEnum,
	MpiEnum,
	MpiSparseEnum,
	MumpsEnum,
	NoFrictionOnPartiallyFloatingEnum,
	NoMeltOnPartiallyFloatingEnum,
	NodalEnum,
	NodalvalueEnum,
	NodeSIdEnum,
	NoneApproximationEnum,
	NoneEnum,
	NumberedcostfunctionEnum,
	NyeCO2Enum,
	NyeH2OEnum,
	NumericalfluxEnum,
	OceantransportAnalysisEnum,
	OceantransportSolutionEnum,
	OldGradientEnum,
	OneLayerP4zEnum,
	OpenEnum,
	OptionEnum,
	ParamEnum,
	ParametersEnum,
	P0ArrayEnum,
	P0DGEnum,
	P1DGEnum,
	P1P1Enum,
	P1P1GLSEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P1xP2Enum,
	P1xP3Enum,
	P1xP4Enum,
	P2Enum,
	P2bubbleEnum,
	P2bubblecondensedEnum,
	P2xP1Enum,
	P2xP4Enum,
	PatersonEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaInputEnum,
	ProfilerEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingCurrentMemEnum,
	ProfilingSolutionTimeEnum,
	RegionaloutputEnum,
	RegularEnum,
	RecoveryAnalysisEnum,
	RiftfrontEnum,
	SamplingAnalysisEnum,
	SamplingSolutionEnum,
	SIAApproximationEnum,
	SMBcomponentsEnum,
	SMBd18opddEnum,
	SMBforcingEnum,
	SMBgcmEnum,
	SMBgembEnum,
	SMBgradientsEnum,
	SMBgradientscomponentsEnum,
	SMBgradientselaEnum,
	SMBhenningEnum,
	SMBmeltcomponentsEnum,
	SMBpddEnum,
	SMBpddSicopolisEnum,
	SMBsemicEnum,
	SSAApproximationEnum,
	SSAFSApproximationEnum,
	SSAHOApproximationEnum,
	ScaledEnum,
	SealevelAbsoluteEnum,
	SealevelEmotionEnum,
	SealevelInertiaTensorXZEnum,
	SealevelInertiaTensorYZEnum,
	SealevelInertiaTensorZZEnum,
	SealevelchangePolarMotionEnum,
	SealevelNmotionEnum,
	SealevelUmotionEnum,
	SealevelchangeAnalysisEnum,
	SegEnum,
	SegInputEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SeparateEnum,
	SeqEnum,
	SmbAnalysisEnum,
	SmbSolutionEnum,
	SmoothAnalysisEnum,
	SoftMigrationEnum,
	SpatialLinearFloatingMeltRateEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	SsetEnum,
	StatisticsSolutionEnum,
	SteadystateSolutionEnum,
	StressIntensityFactorEnum,
	StressbalanceAnalysisEnum,
	StressbalanceConvergenceNumStepsEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	StringArrayParamEnum,
	StringExternalResultEnum,
	StringParamEnum,
	SubelementFriction1Enum,
	SubelementFriction2Enum,
	SubelementMelt1Enum,
	SubelementMelt2Enum,
	SubelementMigrationEnum,
	SurfaceSlopeSolutionEnum,
	TaylorHoodEnum,
	TetraEnum,
	TetraInputEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	ThicknessErrorEstimatorEnum,
	TotalCalvingFluxLevelsetEnum,
	TotalCalvingMeltingFluxLevelsetEnum,
	TotalFloatingBmbEnum,
	TotalFloatingBmbScaledEnum,
	TotalGroundedBmbEnum,
	TotalGroundedBmbScaledEnum,
	TotalSmbEnum,
	TotalSmbScaledEnum,
	TransientArrayParamEnum,
	TransientInputEnum,
	TransientParamEnum,
	TransientSolutionEnum,
	TriaEnum,
	TriaInputEnum,
	UzawaPressureAnalysisEnum,
	VectorParamEnum,
	VertexEnum,
	VertexLIdEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	VerticesEnum,
	ViscousHeatingEnum,
	WaterEnum,
	XTaylorHoodEnum,
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Unused?{{{*/
	BalancethicknessD0Enum,
	BalancethicknessDiffusionCoefficientEnum,
	BilinearInterpEnum,
	CalvingdevCoeffEnum,
	DeviatoricStressEnum,
	EtaAbsGradientEnum,
	MeshZEnum,
	NearestInterpEnum,
	OutputdefinitionListEnum,
	SealevelObsEnum,
	SealevelWeightsEnum,
	StrainRateEnum,
	StressTensorEnum,
	StressbalanceViscosityOvershootEnum,
	SubelementMigration4Enum,
	TimesteppingTimeAdaptEnum,
	TriangleInterpEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
