/*!\file GrdLoads.h
 * \brief: header file for GrdLoads
 */

#ifndef _SEALEVELGRDLOADS_H_
#define _SEALEVELGRDLOADS_H_

/*Headers:*/
#include "./SealevelGeometry.h"
#include "../toolkits/toolkits.h"

class GrdLoads{ 

	public: 

		Vector<IssmDouble>* vloads=NULL;
		IssmDouble*         loads=NULL;
		Vector<IssmDouble>* vsubloads[SLGEOM_NUMLOADS];
		IssmDouble*         subloads[SLGEOM_NUMLOADS];
		Vector<IssmDouble>* vsealevelloads=NULL;
		IssmDouble*         sealevelloads=NULL;
		Vector<IssmDouble>* vsubsealevelloads=NULL;
		IssmDouble*         subsealevelloads=NULL;

		GrdLoads(int nel, SealevelGeometry* slgeom);
		~GrdLoads();

		void AssembleSealevelLoads(void);
		void BroadcastLoads(void);
		void BroadcastSealevelLoads(void);
};
#endif  /* _SEALEVELGRDLOADS_H_ */
