#!/bin/bash
set -eu


## Constants
#
VER="3.13.6"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-${VER}.tar.gz' 'petsc-${VER}.tar.gz'

# Unpack source
tar -zxvf petsc-${VER}.tar.gz

# Cleanup
rm -rf ${PREFIX} ${PETSC_DIR}
mkdir ${PETSC_DIR}

# Move source to $PETSC_DIR
mv petsc-${VER}/* ${PETSC_DIR}
rm -rf petsc-${VER}


# Configure
#
# NOTE: Based on /nasa/petsc/3.7.5/intel_mpt/lib/petsc/conf/petscvariables; look for CONFIGURE_OPTIONS
#
cd ${PETSC_DIR}
./config/configure.py \
	--prefix="${PREFIX}" \
	--PETSC_DIR="${PETSC_DIR}" \
	--with-cc=icc --with-cxx=icpc --with-fc=ifort --with-f77=ifort\
	-COPTFLAGS="-g -O3 -axCORE-AVX2,AVX -xSSE4.2" -CXXOPTFLAGS="-g -O3 -axCORE-AVX2,AVX -xSSE4.2" -FOPTFLAGS="-g -O3 -axCORE-AVX2,AVX -xSSE4.2" \
	--with-blas-lapack-dir="/nasa/intel/Compiler/2016.2.181/compilers_and_libraries_2016.2.181/linux/mkl/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1

# Compile and install
make
make install
