#!/bin/bash
set -eu

## Constants
#
VER="3.12.3"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/petsc-lite-${VER}.tar.gz" "petsc-${VER}.tar.gz"

# Unpack source
tar -zxvf petsc-${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv petsc-${VER}/* src/
rm -rf petsc-${VER}

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-mpi-dir="/opt/cray/pe/mpt/7.7.3/gni/mpich-intel/16.0/" \
	--with-blas-lapack-dir="$TACC_MKL_LIB" \
	--with-scalapack-include="$TACC_MKL_INC" \
	--with-scalapack-lib="$TACC_MKL_LIB/libmkl_scalapack_lp64.so $TACC_MKL_LIB/libmkl_blacs_intelmpi_lp64.so" \
	--with-shared-libraries=1 \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch  \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1

# Compile and install
make
make install
