#!/bin/bash
#This script compiles and links MITgcm

#recover hostname and model path:
hostname="$1"
modelpath="$2"

if [ -e ~/.bashrc ]; then
    source ~/.bashrc
fi

# Get MITgcm code, if needed
if [ ! -d "$modelpath/../MITgcm/install" ]; then
    cd $modelpath/../MITgcm
    source install.sh
    cd $modelpath
fi

# Create build directory, if needed
cd $modelpath
if [ ! -d "build" ]; then mkdir build; fi
cd build

#create MITgcm makefile for this run, if needed
if [ ! -f Makefile ]; then
    if [ $hostname == "pleiades" ]; then 
	$modelpath/../MITgcm/install/tools/genmake2 -of $SLR_DIR/models/ice-ocean/configs/linux_amd64_gfortran+mpi_ice_nas -mo ../code -rd $modelpath/../MITgcm/install
    else
	$modelpath/../MITgcm/install/tools/genmake2 -mpi -mo $modelpath/../MITgcm/code -rd $modelpath/../MITgcm/install
    fi
fi

#create MITgcm code links for this run, if needed
if [ ! -f BUILD_INFO.h ]; then
    make depend
fi

make -j 4
