/*
 * \file GrdLoads.cpp
 * \brief: Implementation of GrdLoads class
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./GrdLoads.h"
#include "./SealevelGeometry.h"
using namespace std;
/*}}}*/

/*Object constructors and destructor*/
GrdLoads::GrdLoads(int nel,SealevelGeometry* slgeom){ /*{{{*/


	vloads=new Vector<IssmDouble>(nel);
	for (int i=0;i<SLGEOM_NUMLOADS;i++) vsubloads[i]=new Vector<IssmDouble>(slgeom->nbar[i]);

	vsealevelloads=new Vector<IssmDouble>(nel);
	vsealevelloads->Set(0);vsealevelloads->Assemble();

	vsubsealevelloads=new Vector<IssmDouble>(slgeom->nbar[SLGEOM_OCEAN]);


}; /*}}}*/
GrdLoads::~GrdLoads(){ /*{{{*/

	delete vloads;
	xDelete<IssmDouble>(loads);
	for(int i=0;i<SLGEOM_NUMLOADS;i++){
		delete vsubloads[i];
		xDelete<IssmDouble>(subloads[i]);
	}
	delete vsealevelloads;
	xDelete<IssmDouble>(sealevelloads);
	delete vsubsealevelloads;
	xDelete<IssmDouble>(subsealevelloads);
}; /*}}}*/

void GrdLoads::BroadcastLoads(void){ /*{{{*/

	/*Initialize barycentre vectors, now that we know their size: */
	vloads->Assemble();
	for (int i=0;i<SLGEOM_NUMLOADS;i++){
		vsubloads[i]->Assemble();
	}
	
	loads=vloads->ToMPISerial();
	for (int i=0;i<SLGEOM_NUMLOADS;i++){
		subloads[i]=vsubloads[i]->ToMPISerial();
	}

} /*}}}*/
void GrdLoads::AssembleSealevelLoads(void){ /*{{{*/

	vsealevelloads->Assemble();
	vsubsealevelloads->Assemble();

} /*}}}*/
void GrdLoads::BroadcastSealevelLoads(void){ /*{{{*/
	
	sealevelloads=vsealevelloads->ToMPISerial();
	subsealevelloads=vsubsealevelloads->ToMPISerial();

} /*}}}*/
