function [y, m, d] = fractionYear2Datetime(fy); 
% a function to compute year, month, date from a fraction year. 
% 
% usage: 
%		[y, m, d] = fractionYear2Datetime(fy); 
%		
%		y = year 
%		m = month  
%		d = day 
%		fy = fraction year (e.g., 2007.391) 
%		

yr = fix(fy);	% year  
secs = (fy-yr).*(365+leapyear(yr))*24*3600; % seconds in the year
dn = fix(datenum(yr,1,0,0,0,secs));	
ds = cellstr(datestr(dn,24));
dt = datetime(ds,'InputFormat','dd/MM/yyyy');
[y,m,d] = ymd(dt); 

