function printmodel(filename,format)
%PRINTMODEL - save an image of current figure
%
%   the format is the same as the one accepted by the builtin imwrite routine.
%
%   Usage:
%      printmodel(filename,format)

%Get current figure
fig=gcf;

%In auto mode, MATLAB prints the figure the same size as it appears on the computer screen, centered on the page
set(fig, 'PaperPositionMode', 'auto');

%InvertHardcopy off imposes MATLAB to use the same colors
set(fig, 'InvertHardcopy', 'off');

%Use higher resolution to anti-alias and use zbuffer to have smooth colors
print(fig, '-zbuffer', ['-r' num2str(get(0,'ScreenPixelsPerInch')*2)], ['-d' format],filename);

%Add frame except if pdf
if ~strcmpi(format,'pdf'),
	system(['convert -border 1x1 -bordercolor "#000000" ' filename ' ' filename ]);
end
