/*!\file Cflevelsetmisfit.h
 * \brief: header file for Cflevelsetmisfit object
 */

#ifndef _CFLEVELSETMISFIT_H_
#define _CFLEVELSETMISFIT_H_

/*Headers:*/
#include "./Definition.h"
#include "./FemModel.h"

IssmDouble OutputDefinitionsResponsex(FemModel* femmodel,int output_enum);
void  GetVectorFromInputsx( IssmDouble** pvector, int* pvector_size, FemModel* femmodel,int name);

class Cflevelsetmisfit: public Object, public Definition{

	public: 

		int         definitionenum;
		int         local;     
		int         model_enum;
		char*       name;
		int         observation_enum;
		char*       timeinterpolation;
		int         weights_enum;
		IssmDouble	datatime;
		bool			timepassedflag;
		
		IssmDouble  misfit; //value carried over in time.
		
		/*Cflevelsetmisfit constructors, destructors :*/
		Cflevelsetmisfit();
		Cflevelsetmisfit(char* in_name, int in_definitionenum, int in_model_enum, int in_observation_enum, int in_weights_enum, IssmDouble in_datatime, bool timepassedflag);
		~Cflevelsetmisfit();
		
		/*Object virtual function resolutoin: */
		Object* copy();
		void DeepEcho(void);
		void Echo(void);
		int Id(void);
		void Marshall(MarshallHandle* marshallhandle);
		int ObjectEnum(void);
		
		/*Definition virtual function resolutoin: */
		int DefinitionEnum();
		char* Name();
		IssmDouble Response(FemModel* femmodel);
		IssmDouble Cflevelsetmisfit_Calculation(Element* element, int model_enum, int observation_enum, int weights_enum);
		IssmDouble Heaviside(IssmDouble x);
};
#endif  /* _CFLEVELSETMISFIT_H_ */
