/*
 * \file SealevelGeometry.cpp
 * \brief: Implementation of SealevelGeometry class
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./SealevelGeometry.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
SealevelGeometry::SealevelGeometry(int localnelin,int localnodsin){ /*{{{*/
	localnel=localnelin;
	for(int i=0;i<SLGEOM_NUMLOADS;i++){
		for (int j=0;j<SLMAXVERTICES;j++){
			LoadWeigths[i][j]=xNewZeroInit<IssmDouble>(localnel);
		}
		vlatbarycentre[i]=NULL; //we don't know yet 
		vlongbarycentre[i]=NULL;
		vareae_subel[i]=NULL;
		latbarycentre[i]=NULL; //we don't know yet 
		longbarycentre[i]=NULL;
		area_subel[i]=NULL;

		LoadArea[i]=xNewZeroInit<IssmDouble>(localnel);
		issubelement[i]=xNewZeroInit<bool>(localnel);
		subelementmapping[i]=NULL;
		nsubel[i]=0;
		nbar[i]=0;
	}
	late=xNew<IssmDouble>(localnel);
	longe=xNew<IssmDouble>(localnel);
	isoceanin=xNew<bool>(localnel);
	lids=xNew<int>(localnodsin);

}; /*}}}*/
SealevelGeometry::~SealevelGeometry(){ /*{{{*/
	for(int i=0;i<SLGEOM_NUMLOADS;i++){
		for (int j=0;j<SLMAXVERTICES;j++){
			xDelete<IssmDouble>(LoadWeigths[i][j]);
		}
		xDelete<IssmDouble>(LoadArea[i]);
		xDelete<bool>(issubelement[i]);
		xDelete<int>(subelementmapping[i]);
		delete  vlatbarycentre[i];
		delete  vlongbarycentre[i];
		delete  vareae_subel[i];
		xDelete<IssmDouble>(latbarycentre[i]);
		xDelete<IssmDouble>(longbarycentre[i]);
		xDelete<IssmDouble>(area_subel[i]);
	}
	xDelete<IssmDouble>(late);
	xDelete<IssmDouble>(longe);
	xDelete<bool>(isoceanin);
	xDelete<int>(lids);
}; /*}}}*/

void SealevelGeometry::InitializeMappingsAndBarycentres(void){ /*{{{*/

	int dummy;
	bool fromlocalsize=true;
	int lower_row;


	for (int i=0;i<SLGEOM_NUMLOADS;i++){
		subelementmapping[i]=xNew<int>(localnel);
		GetOwnershipBoundariesFromRange(&lower_row,&dummy,nsubel[i],IssmComm::GetComm());

		int count=0;
		for (int j=0;j<localnel;j++){
			if(issubelement[i][j]){
				subelementmapping[i][j]=lower_row+count;
				count++;
			}
		}
	}

	/*Initialize barycentre vectors, now that we know their size: */
	for (int i=0;i<SLGEOM_NUMLOADS;i++){
		vlatbarycentre[i]=new Vector<IssmDouble>(nsubel[i],fromlocalsize);
		vlongbarycentre[i]=new Vector<IssmDouble>(nsubel[i],fromlocalsize);
		vareae_subel[i]=new Vector<IssmDouble>(nsubel[i],fromlocalsize);
		vlatbarycentre[i]->GetSize(&nbar[i]);
	}

} /*}}}*/
void SealevelGeometry::Assemble(void){ /*{{{*/

	/*Initialize barycentre vectors, now that we know their size: */
	for (int i=0;i<SLGEOM_NUMLOADS;i++){
		vlatbarycentre[i]->Assemble();
		vlongbarycentre[i]->Assemble();
		vareae_subel[i]->Assemble();

		latbarycentre[i]=vlatbarycentre[i]->ToMPISerial();
		longbarycentre[i]=vlongbarycentre[i]->ToMPISerial();
		area_subel[i]=vareae_subel[i]->ToMPISerial();
	}

	/*Also, we'll need the barycentre associated areas:*/


} /*}}}*/
int SealevelGeometry::GEnum(int l){ /*{{{*/
	
	int output = -1;
	switch(l){
		case SLGEOM_OCEAN: output=SealevelchangeGsubelOceanEnum; break;
		case SLGEOM_ICE:   output=SealevelchangeGsubelIceEnum;   break;
		case SLGEOM_WATER: output=SealevelchangeGsubelHydroEnum; break;
		default: _error_("not supported");
	}
	return output;

} /*}}}*/
int SealevelGeometry::GUEnum(int l){ /*{{{*/
	
	int output = -1;
	switch(l){
		case SLGEOM_OCEAN: output=SealevelchangeGUsubelOceanEnum; break;
		case SLGEOM_ICE:   output=SealevelchangeGUsubelIceEnum;   break;
		case SLGEOM_WATER: output=SealevelchangeGUsubelHydroEnum; break;
		default: _error_("not supported");
	}
	return output;

} /*}}}*/
int SealevelGeometry::GNEnum(int l){ /*{{{*/
	
	int output = -1;
	switch(l){
		case SLGEOM_OCEAN: output=SealevelchangeGNsubelOceanEnum; break;
		case SLGEOM_ICE:   output=SealevelchangeGNsubelIceEnum;   break;
		case SLGEOM_WATER: output=SealevelchangeGNsubelHydroEnum; break;
		default: _error_("not supported");
	}

	return output;
} /*}}}*/
int SealevelGeometry::GEEnum(int l){ /*{{{*/
	
	int output = -1;
	switch(l){
		case SLGEOM_OCEAN: output=SealevelchangeGEsubelOceanEnum; break;
		case SLGEOM_ICE:   output=SealevelchangeGEsubelIceEnum;   break;
		case SLGEOM_WATER: output=SealevelchangeGEsubelHydroEnum; break;
		default: _error_("not supported");
	}
	return output;

} /*}}}*/
