function plotmodel(md,varargin)
%At command prompt, type plotdoc for help on documentation.

global ISSM_DIR
if isempty(ISSM_DIR),
	error('ISSM_DIR variable got erased! This variable is needed to run Ice code correctly. Please rerun your startup file.');
end

%First process options
options=plotoptions(varargin{:});

%get numberof subplot
subplotwidth=ceil(sqrt(options.numberofplots));

%Get figure number and number of plots
figurenumber=options.figurenumber;
numberofplots=options.numberofplots;

%go through subplots
if numberofplots,
		
	%Create figure 
	figure(figurenumber),clf;

	%Use zbuffer renderer (snoother colors)
	set(gcf,'Renderer','zbuffer');

	%Go through all data plottable
	for i=1:numberofplots,

		%call unit plot
		plot_manager(md,options.list{i},subplotwidth,i);

	end
else
	error('plotmodel error message: no output data found. ');
end
