function printmodel(filename,format)
%PRINTMODEL - save an image of current figure
%
%   the format is the same as the one accepted by the builtin imwrite routine.
%
%   Usage:
%      printmodel(filename,format)

%Get current figure
fig=gcf;

%Set the PaperPositionMode property to auto before printing the figure.
%http://www.mathworks.com/access/helpdesk/help/techdoc/creating_plots/f3-124745.html
set(fig, 'PaperPositionMode', 'auto');

%Use higher resolution to anti-alias and use zbuffer to have smooth colors
print(fig, '-zbuffer', ['-r' num2str(get(0,'ScreenPixelsPerInch')*2)], ['-d' format],filename);
